/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.CMPCertificate;
import com.enterprisedt.bouncycastle.asn1.cmp.CertResponse;

public class CertRepMessage
extends ASN1Object {
    private ASN1Sequence a;
    private ASN1Sequence b;

    private CertRepMessage(ASN1Sequence seq) {
        int n2 = 0;
        if (seq.size() > 1) {
            this.a = ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(n2++), true);
        }
        this.b = ASN1Sequence.getInstance(seq.getObjectAt(n2));
    }

    public static CertRepMessage getInstance(Object o2) {
        if (o2 instanceof CertRepMessage) {
            return (CertRepMessage)o2;
        }
        if (o2 != null) {
            return new CertRepMessage(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CertRepMessage(CMPCertificate[] caPubs, CertResponse[] response) {
        int n2;
        ASN1EncodableVector aSN1EncodableVector;
        if (response == null) {
            throw new IllegalArgumentException("'response' cannot be null");
        }
        if (caPubs != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            for (n2 = 0; n2 < caPubs.length; ++n2) {
                aSN1EncodableVector.add(caPubs[n2]);
            }
            this.a = new DERSequence(aSN1EncodableVector);
        }
        aSN1EncodableVector = new ASN1EncodableVector();
        for (n2 = 0; n2 < response.length; ++n2) {
            aSN1EncodableVector.add(response[n2]);
        }
        this.b = new DERSequence(aSN1EncodableVector);
    }

    public CMPCertificate[] getCaPubs() {
        if (this.a == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.a.size()];
        for (int i2 = 0; i2 != cMPCertificateArray.length; ++i2) {
            cMPCertificateArray[i2] = CMPCertificate.getInstance(this.a.getObjectAt(i2));
        }
        return cMPCertificateArray;
    }

    public CertResponse[] getResponse() {
        CertResponse[] certResponseArray = new CertResponse[this.b.size()];
        for (int i2 = 0; i2 != certResponseArray.length; ++i2) {
            certResponseArray[i2] = CertResponse.getInstance(this.b.getObjectAt(i2));
        }
        return certResponseArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.a));
        }
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

