/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.CertOrEncCert;
import com.enterprisedt.bouncycastle.asn1.crmf.EncryptedValue;
import com.enterprisedt.bouncycastle.asn1.crmf.PKIPublicationInfo;

public class CertifiedKeyPair
extends ASN1Object {
    private CertOrEncCert a;
    private EncryptedValue b;
    private PKIPublicationInfo c;

    private CertifiedKeyPair(ASN1Sequence seq) {
        this.a = CertOrEncCert.getInstance(seq.getObjectAt(0));
        if (seq.size() >= 2) {
            if (seq.size() == 2) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(1));
                if (aSN1TaggedObject.getTagNo() == 0) {
                    this.b = EncryptedValue.getInstance(aSN1TaggedObject.getObject());
                } else {
                    this.c = PKIPublicationInfo.getInstance(aSN1TaggedObject.getObject());
                }
            } else {
                this.b = EncryptedValue.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(1)));
                this.c = PKIPublicationInfo.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(2)));
            }
        }
    }

    public static CertifiedKeyPair getInstance(Object o2) {
        if (o2 instanceof CertifiedKeyPair) {
            return (CertifiedKeyPair)o2;
        }
        if (o2 != null) {
            return new CertifiedKeyPair(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CertifiedKeyPair(CertOrEncCert certOrEncCert) {
        this(certOrEncCert, null, null);
    }

    public CertifiedKeyPair(CertOrEncCert certOrEncCert, EncryptedValue privateKey, PKIPublicationInfo publicationInfo) {
        if (certOrEncCert == null) {
            throw new IllegalArgumentException("'certOrEncCert' cannot be null");
        }
        this.a = certOrEncCert;
        this.b = privateKey;
        this.c = publicationInfo;
    }

    public CertOrEncCert getCertOrEncCert() {
        return this.a;
    }

    public EncryptedValue getPrivateKey() {
        return this.b;
    }

    public PKIPublicationInfo getPublicationInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

