/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.crmf.CertId;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OOBCertHash
extends ASN1Object {
    private AlgorithmIdentifier a;
    private CertId b;
    private DERBitString c;

    private OOBCertHash(ASN1Sequence seq) {
        int n2 = seq.size() - 1;
        this.c = DERBitString.getInstance(seq.getObjectAt(n2--));
        for (int i2 = n2; i2 >= 0; --i2) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(i2);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.a = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.b = CertId.getInstance(aSN1TaggedObject, true);
        }
    }

    public static OOBCertHash getInstance(Object o2) {
        if (o2 instanceof OOBCertHash) {
            return (OOBCertHash)o2;
        }
        if (o2 != null) {
            return new OOBCertHash(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public OOBCertHash(AlgorithmIdentifier hashAlg, CertId certId, byte[] hashVal) {
        this(hashAlg, certId, new DERBitString(hashVal));
    }

    public OOBCertHash(AlgorithmIdentifier hashAlg, CertId certId, DERBitString hashVal) {
        this.a = hashAlg;
        this.b = certId;
        this.c = hashVal;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.a;
    }

    public CertId getCertId() {
        return this.b;
    }

    public DERBitString getHashVal() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.a(aSN1EncodableVector, 0, this.a);
        this.a(aSN1EncodableVector, 1, this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

