/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.InfoTypeAndValue;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIFreeText;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIHeader;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;

public class PKIHeaderBuilder {
    private ASN1Integer a;
    private GeneralName b;
    private GeneralName c;
    private ASN1GeneralizedTime d;
    private AlgorithmIdentifier e;
    private ASN1OctetString f;
    private ASN1OctetString g;
    private ASN1OctetString h;
    private ASN1OctetString i;
    private ASN1OctetString j;
    private PKIFreeText k;
    private ASN1Sequence l;

    public PKIHeaderBuilder(int pvno, GeneralName sender, GeneralName recipient) {
        this(new ASN1Integer(pvno), sender, recipient);
    }

    private PKIHeaderBuilder(ASN1Integer pvno, GeneralName sender, GeneralName recipient) {
        this.a = pvno;
        this.b = sender;
        this.c = recipient;
    }

    public PKIHeaderBuilder setMessageTime(ASN1GeneralizedTime time) {
        this.d = time;
        return this;
    }

    public PKIHeaderBuilder setProtectionAlg(AlgorithmIdentifier aid) {
        this.e = aid;
        return this;
    }

    public PKIHeaderBuilder setSenderKID(byte[] kid) {
        return this.setSenderKID(kid == null ? null : new DEROctetString(kid));
    }

    public PKIHeaderBuilder setSenderKID(ASN1OctetString kid) {
        this.f = kid;
        return this;
    }

    public PKIHeaderBuilder setRecipKID(byte[] kid) {
        return this.setRecipKID(kid == null ? null : new DEROctetString(kid));
    }

    public PKIHeaderBuilder setRecipKID(DEROctetString kid) {
        this.g = kid;
        return this;
    }

    public PKIHeaderBuilder setTransactionID(byte[] tid) {
        return this.setTransactionID(tid == null ? null : new DEROctetString(tid));
    }

    public PKIHeaderBuilder setTransactionID(ASN1OctetString tid) {
        this.h = tid;
        return this;
    }

    public PKIHeaderBuilder setSenderNonce(byte[] nonce) {
        return this.setSenderNonce(nonce == null ? null : new DEROctetString(nonce));
    }

    public PKIHeaderBuilder setSenderNonce(ASN1OctetString nonce) {
        this.i = nonce;
        return this;
    }

    public PKIHeaderBuilder setRecipNonce(byte[] nonce) {
        return this.setRecipNonce(nonce == null ? null : new DEROctetString(nonce));
    }

    public PKIHeaderBuilder setRecipNonce(ASN1OctetString nonce) {
        this.j = nonce;
        return this;
    }

    public PKIHeaderBuilder setFreeText(PKIFreeText text) {
        this.k = text;
        return this;
    }

    public PKIHeaderBuilder setGeneralInfo(InfoTypeAndValue genInfo) {
        return this.setGeneralInfo(PKIHeaderBuilder.a(genInfo));
    }

    public PKIHeaderBuilder setGeneralInfo(InfoTypeAndValue[] genInfos) {
        return this.setGeneralInfo(PKIHeaderBuilder.a(genInfos));
    }

    public PKIHeaderBuilder setGeneralInfo(ASN1Sequence seqOfInfoTypeAndValue) {
        this.l = seqOfInfoTypeAndValue;
        return this;
    }

    private static ASN1Sequence a(InfoTypeAndValue infoTypeAndValue) {
        return new DERSequence(infoTypeAndValue);
    }

    private static ASN1Sequence a(InfoTypeAndValue[] infoTypeAndValueArray) {
        DERSequence dERSequence = null;
        if (infoTypeAndValueArray != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (int i2 = 0; i2 < infoTypeAndValueArray.length; ++i2) {
                aSN1EncodableVector.add(infoTypeAndValueArray[i2]);
            }
            dERSequence = new DERSequence(aSN1EncodableVector);
        }
        return dERSequence;
    }

    public PKIHeader build() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        this.a(aSN1EncodableVector, 0, this.d);
        this.a(aSN1EncodableVector, 1, this.e);
        this.a(aSN1EncodableVector, 2, this.f);
        this.a(aSN1EncodableVector, 3, this.g);
        this.a(aSN1EncodableVector, 4, this.h);
        this.a(aSN1EncodableVector, 5, this.i);
        this.a(aSN1EncodableVector, 6, this.j);
        this.a(aSN1EncodableVector, 7, this.k);
        this.a(aSN1EncodableVector, 8, this.l);
        this.d = null;
        this.e = null;
        this.f = null;
        this.g = null;
        this.h = null;
        this.i = null;
        this.j = null;
        this.k = null;
        this.l = null;
        return PKIHeader.getInstance(new DERSequence(aSN1EncodableVector));
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

