/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.CMPCertificate;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIBody;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIHeader;
import java.util.Enumeration;

public class PKIMessage
extends ASN1Object {
    private PKIHeader a;
    private PKIBody b;
    private DERBitString c;
    private ASN1Sequence d;

    private PKIMessage(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = PKIHeader.getInstance(enumeration.nextElement());
        this.b = PKIBody.getInstance(enumeration.nextElement());
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.c = DERBitString.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.d = ASN1Sequence.getInstance(aSN1TaggedObject, true);
        }
    }

    public static PKIMessage getInstance(Object o2) {
        if (o2 instanceof PKIMessage) {
            return (PKIMessage)o2;
        }
        if (o2 != null) {
            return new PKIMessage(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PKIMessage(PKIHeader header, PKIBody body, DERBitString protection, CMPCertificate[] extraCerts) {
        this.a = header;
        this.b = body;
        this.c = protection;
        if (extraCerts != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            for (int i2 = 0; i2 < extraCerts.length; ++i2) {
                aSN1EncodableVector.add(extraCerts[i2]);
            }
            this.d = new DERSequence(aSN1EncodableVector);
        }
    }

    public PKIMessage(PKIHeader header, PKIBody body, DERBitString protection) {
        this(header, body, protection, null);
    }

    public PKIMessage(PKIHeader header, PKIBody body) {
        this(header, body, null, null);
    }

    public PKIHeader getHeader() {
        return this.a;
    }

    public PKIBody getBody() {
        return this.b;
    }

    public DERBitString getProtection() {
        return this.c;
    }

    public CMPCertificate[] getExtraCerts() {
        if (this.d == null) {
            return null;
        }
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[this.d.size()];
        for (int i2 = 0; i2 < cMPCertificateArray.length; ++i2) {
            cMPCertificateArray[i2] = CMPCertificate.getInstance(this.d.getObjectAt(i2));
        }
        return cMPCertificateArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        this.a(aSN1EncodableVector, 0, this.c);
        this.a(aSN1EncodableVector, 1, this.d);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, n2, aSN1Encodable));
        }
    }
}

