/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIFreeText;

public class PollRepContent
extends ASN1Object {
    private ASN1Integer[] a;
    private ASN1Integer[] b;
    private PKIFreeText[] c;

    private PollRepContent(ASN1Sequence seq) {
        this.a = new ASN1Integer[seq.size()];
        this.b = new ASN1Integer[seq.size()];
        this.c = new PKIFreeText[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(seq.getObjectAt(i2));
            this.a[i2] = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
            this.b[i2] = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() <= 2) continue;
            this.c[i2] = PKIFreeText.getInstance(aSN1Sequence.getObjectAt(2));
        }
    }

    public static PollRepContent getInstance(Object o2) {
        if (o2 instanceof PollRepContent) {
            return (PollRepContent)o2;
        }
        if (o2 != null) {
            return new PollRepContent(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PollRepContent(ASN1Integer certReqId, ASN1Integer checkAfter) {
        this(certReqId, checkAfter, null);
    }

    public PollRepContent(ASN1Integer certReqId, ASN1Integer checkAfter, PKIFreeText reason) {
        this.a = new ASN1Integer[1];
        this.b = new ASN1Integer[1];
        this.c = new PKIFreeText[1];
        this.a[0] = certReqId;
        this.b[0] = checkAfter;
        this.c[0] = reason;
    }

    public int size() {
        return this.a.length;
    }

    public ASN1Integer getCertReqId(int index) {
        return this.a[index];
    }

    public ASN1Integer getCheckAfter(int index) {
        return this.b[index];
    }

    public PKIFreeText getReason(int index) {
        return this.c[index];
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(this.a[i2]);
            aSN1EncodableVector2.add(this.b[i2]);
            if (this.c[i2] != null) {
                aSN1EncodableVector2.add(this.c[i2]);
            }
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

