/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatus;
import com.enterprisedt.bouncycastle.asn1.crmf.CertId;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;

public class RevAnnContent
extends ASN1Object {
    private PKIStatus a;
    private CertId b;
    private ASN1GeneralizedTime c;
    private ASN1GeneralizedTime d;
    private Extensions e;

    private RevAnnContent(ASN1Sequence seq) {
        this.a = PKIStatus.getInstance(seq.getObjectAt(0));
        this.b = CertId.getInstance(seq.getObjectAt(1));
        this.c = ASN1GeneralizedTime.getInstance(seq.getObjectAt(2));
        this.d = ASN1GeneralizedTime.getInstance(seq.getObjectAt(3));
        if (seq.size() > 4) {
            this.e = Extensions.getInstance(seq.getObjectAt(4));
        }
    }

    public static RevAnnContent getInstance(Object o2) {
        if (o2 instanceof RevAnnContent) {
            return (RevAnnContent)o2;
        }
        if (o2 != null) {
            return new RevAnnContent(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PKIStatus getStatus() {
        return this.a;
    }

    public CertId getCertId() {
        return this.b;
    }

    public ASN1GeneralizedTime getWillBeRevokedAt() {
        return this.c;
    }

    public ASN1GeneralizedTime getBadSinceDate() {
        return this.d;
    }

    public Extensions getCrlDetails() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

