/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cmp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.crmf.CertTemplate;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;

public class RevDetails
extends ASN1Object {
    private CertTemplate a;
    private Extensions b;

    private RevDetails(ASN1Sequence seq) {
        this.a = CertTemplate.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.b = Extensions.getInstance(seq.getObjectAt(1));
        }
    }

    public static RevDetails getInstance(Object o2) {
        if (o2 instanceof RevDetails) {
            return (RevDetails)o2;
        }
        if (o2 != null) {
            return new RevDetails(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public RevDetails(CertTemplate certDetails) {
        this.a = certDetails;
    }

    public RevDetails(CertTemplate certDetails, X509Extensions crlEntryDetails) {
        this.a = certDetails;
        this.b = Extensions.getInstance(crlEntryDetails.toASN1Primitive());
    }

    public RevDetails(CertTemplate certDetails, Extensions crlEntryDetails) {
        this.a = certDetails;
        this.b = crlEntryDetails;
    }

    public CertTemplate getCertDetails() {
        return this.a;
    }

    public Extensions getCrlEntryDetails() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

