/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DERSet;
import com.enterprisedt.bouncycastle.asn1.cms.Attribute;
import com.enterprisedt.bouncycastle.asn1.cms.Attributes;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AttributeTable {
    private Hashtable a = new Hashtable();

    public AttributeTable(Hashtable attrs) {
        this.a = this.a(attrs);
    }

    public AttributeTable(ASN1EncodableVector v2) {
        for (int i2 = 0; i2 != v2.size(); ++i2) {
            Attribute attribute = Attribute.getInstance(v2.get(i2));
            this.a(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(ASN1Set s2) {
        for (int i2 = 0; i2 != s2.size(); ++i2) {
            Attribute attribute = Attribute.getInstance(s2.getObjectAt(i2));
            this.a(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(Attribute attr) {
        this.a(attr.getAttrType(), attr);
    }

    public AttributeTable(Attributes attrs) {
        this(ASN1Set.getInstance(attrs.toASN1Primitive()));
    }

    private void a(ASN1ObjectIdentifier aSN1ObjectIdentifier, Attribute attribute) {
        Object v2 = this.a.get(aSN1ObjectIdentifier);
        if (v2 == null) {
            this.a.put(aSN1ObjectIdentifier, attribute);
        } else {
            Vector<Object> vector;
            if (v2 instanceof Attribute) {
                vector = new Vector<Object>();
                vector.addElement(v2);
                vector.addElement(attribute);
            } else {
                vector = (Vector<Object>)v2;
                vector.addElement(attribute);
            }
            this.a.put(aSN1ObjectIdentifier, vector);
        }
    }

    public Attribute get(ASN1ObjectIdentifier oid) {
        Object v2 = this.a.get(oid);
        if (v2 instanceof Vector) {
            return (Attribute)((Vector)v2).elementAt(0);
        }
        return (Attribute)v2;
    }

    public ASN1EncodableVector getAll(ASN1ObjectIdentifier oid) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Object v2 = this.a.get(oid);
        if (v2 instanceof Vector) {
            Enumeration enumeration = ((Vector)v2).elements();
            while (enumeration.hasMoreElements()) {
                aSN1EncodableVector.add((Attribute)enumeration.nextElement());
            }
        } else if (v2 != null) {
            aSN1EncodableVector.add((Attribute)v2);
        }
        return aSN1EncodableVector;
    }

    public int size() {
        int n2 = 0;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Object v2 = enumeration.nextElement();
            if (v2 instanceof Vector) {
                n2 += ((Vector)v2).size();
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public Hashtable toHashtable() {
        return this.a(this.a);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Object v2 = enumeration.nextElement();
            if (v2 instanceof Vector) {
                Enumeration enumeration2 = ((Vector)v2).elements();
                while (enumeration2.hasMoreElements()) {
                    aSN1EncodableVector.add(Attribute.getInstance(enumeration2.nextElement()));
                }
                continue;
            }
            aSN1EncodableVector.add(Attribute.getInstance(v2));
        }
        return aSN1EncodableVector;
    }

    public Attributes toASN1Structure() {
        return new Attributes(this.toASN1EncodableVector());
    }

    private Hashtable a(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            hashtable2.put(k2, hashtable.get(k2));
        }
        return hashtable2;
    }

    public AttributeTable add(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        AttributeTable attributeTable = new AttributeTable(this.a);
        attributeTable.a(attrType, new Attribute(attrType, new DERSet(attrValue)));
        return attributeTable;
    }

    public AttributeTable remove(ASN1ObjectIdentifier attrType) {
        AttributeTable attributeTable = new AttributeTable(this.a);
        attributeTable.a.remove(attrType);
        return attributeTable;
    }
}

