/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class ContentInfo
extends ASN1Object
implements CMSObjectIdentifiers {
    private ASN1ObjectIdentifier a;
    private ASN1Encodable b;

    public static ContentInfo getInstance(Object obj) {
        if (obj instanceof ContentInfo) {
            return (ContentInfo)obj;
        }
        if (obj != null) {
            return new ContentInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static ContentInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ContentInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public ContentInfo(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(1);
            if (!aSN1TaggedObject.isExplicit() || aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("Bad tag for 'content'");
            }
            this.b = aSN1TaggedObject.getObject();
        }
    }

    public ContentInfo(ASN1ObjectIdentifier contentType, ASN1Encodable content) {
        this.a = contentType;
        this.b = content;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.a;
    }

    public ASN1Encodable getContent() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new BERTaggedObject(0, this.b));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

