/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.cms.ContentInfo;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class DigestedData
extends ASN1Object {
    private ASN1Integer a;
    private AlgorithmIdentifier b;
    private ContentInfo c;
    private ASN1OctetString d;

    public DigestedData(AlgorithmIdentifier digestAlgorithm, ContentInfo encapContentInfo, byte[] digest) {
        this.a = new ASN1Integer(0L);
        this.b = digestAlgorithm;
        this.c = encapContentInfo;
        this.d = new DEROctetString(digest);
    }

    private DigestedData(ASN1Sequence seq) {
        this.a = (ASN1Integer)seq.getObjectAt(0);
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.c = ContentInfo.getInstance(seq.getObjectAt(2));
        this.d = ASN1OctetString.getInstance(seq.getObjectAt(3));
    }

    public static DigestedData getInstance(ASN1TaggedObject ato, boolean isExplicit) {
        return DigestedData.getInstance(ASN1Sequence.getInstance(ato, isExplicit));
    }

    public static DigestedData getInstance(Object obj) {
        if (obj instanceof DigestedData) {
            return (DigestedData)obj;
        }
        if (obj != null) {
            return new DigestedData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.b;
    }

    public ContentInfo getEncapContentInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new BERSequence(aSN1EncodableVector);
    }

    public byte[] getDigest() {
        return this.d.getOctets();
    }
}

