/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.BERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.EncryptedContentInfo;

public class EncryptedData
extends ASN1Object {
    private ASN1Integer a;
    private EncryptedContentInfo b;
    private ASN1Set c;

    public static EncryptedData getInstance(Object o2) {
        if (o2 instanceof EncryptedData) {
            return (EncryptedData)o2;
        }
        if (o2 != null) {
            return new EncryptedData(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public EncryptedData(EncryptedContentInfo encInfo) {
        this(encInfo, null);
    }

    public EncryptedData(EncryptedContentInfo encInfo, ASN1Set unprotectedAttrs) {
        this.a = new ASN1Integer(unprotectedAttrs == null ? 0L : 2L);
        this.b = encInfo;
        this.c = unprotectedAttrs;
    }

    private EncryptedData(ASN1Sequence seq) {
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        this.b = EncryptedContentInfo.getInstance(seq.getObjectAt(1));
        if (seq.size() == 3) {
            this.c = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(2), false);
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.b;
    }

    public ASN1Set getUnprotectedAttrs() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(new BERTaggedObject(false, 1, this.c));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

