/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.Attributes;
import com.enterprisedt.bouncycastle.asn1.cms.EncryptedContentInfo;
import com.enterprisedt.bouncycastle.asn1.cms.OriginatorInfo;
import com.enterprisedt.bouncycastle.asn1.cms.RecipientInfo;
import java.util.Enumeration;

public class EnvelopedData
extends ASN1Object {
    private ASN1Integer a;
    private OriginatorInfo b;
    private ASN1Set c;
    private EncryptedContentInfo d;
    private ASN1Set e;

    public EnvelopedData(OriginatorInfo originatorInfo, ASN1Set recipientInfos, EncryptedContentInfo encryptedContentInfo, ASN1Set unprotectedAttrs) {
        this.a = new ASN1Integer(EnvelopedData.calculateVersion(originatorInfo, recipientInfos, unprotectedAttrs));
        this.b = originatorInfo;
        this.c = recipientInfos;
        this.d = encryptedContentInfo;
        this.e = unprotectedAttrs;
    }

    public EnvelopedData(OriginatorInfo originatorInfo, ASN1Set recipientInfos, EncryptedContentInfo encryptedContentInfo, Attributes unprotectedAttrs) {
        this.a = new ASN1Integer(EnvelopedData.calculateVersion(originatorInfo, recipientInfos, ASN1Set.getInstance(unprotectedAttrs)));
        this.b = originatorInfo;
        this.c = recipientInfos;
        this.d = encryptedContentInfo;
        this.e = ASN1Set.getInstance(unprotectedAttrs);
    }

    public EnvelopedData(ASN1Sequence seq) {
        int n2 = 0;
        this.a = (ASN1Integer)seq.getObjectAt(n2++);
        ASN1Encodable aSN1Encodable = seq.getObjectAt(n2++);
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            this.b = OriginatorInfo.getInstance((ASN1TaggedObject)aSN1Encodable, false);
            aSN1Encodable = seq.getObjectAt(n2++);
        }
        this.c = ASN1Set.getInstance(aSN1Encodable);
        this.d = EncryptedContentInfo.getInstance(seq.getObjectAt(n2++));
        if (seq.size() > n2) {
            this.e = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(n2), false);
        }
    }

    public static EnvelopedData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return EnvelopedData.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static EnvelopedData getInstance(Object obj) {
        if (obj instanceof EnvelopedData) {
            return (EnvelopedData)obj;
        }
        if (obj != null) {
            return new EnvelopedData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.b;
    }

    public ASN1Set getRecipientInfos() {
        return this.c;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.d;
    }

    public ASN1Set getUnprotectedAttrs() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.e));
        }
        return new BERSequence(aSN1EncodableVector);
    }

    public static int calculateVersion(OriginatorInfo originatorInfo, ASN1Set recipientInfos, ASN1Set unprotectedAttrs) {
        int n2;
        if (originatorInfo != null || unprotectedAttrs != null) {
            n2 = 2;
        } else {
            n2 = 0;
            Enumeration enumeration = recipientInfos.getObjects();
            while (enumeration.hasMoreElements()) {
                RecipientInfo recipientInfo = RecipientInfo.getInstance(enumeration.nextElement());
                if (recipientInfo.getVersion().getValue().intValue() == n2) continue;
                n2 = 2;
                break;
            }
        }
        return n2;
    }
}

