/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.enterprisedt.bouncycastle.asn1.cms.RecipientKeyIdentifier;

public class KeyAgreeRecipientIdentifier
extends ASN1Object
implements ASN1Choice {
    private IssuerAndSerialNumber a;
    private RecipientKeyIdentifier b;

    public static KeyAgreeRecipientIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return KeyAgreeRecipientIdentifier.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new KeyAgreeRecipientIdentifier(IssuerAndSerialNumber.getInstance(obj));
        }
        if (obj instanceof ASN1TaggedObject && ((ASN1TaggedObject)obj).getTagNo() == 0) {
            return new KeyAgreeRecipientIdentifier(RecipientKeyIdentifier.getInstance((ASN1TaggedObject)obj, false));
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier: " + obj.getClass().getName());
    }

    public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber issuerSerial) {
        this.a = issuerSerial;
        this.b = null;
    }

    public KeyAgreeRecipientIdentifier(RecipientKeyIdentifier rKeyID) {
        this.a = null;
        this.b = rKeyID;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.a;
    }

    public RecipientKeyIdentifier getRKeyID() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.b);
    }
}

