/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyAgreeRecipientInfo
extends ASN1Object {
    private ASN1Integer a;
    private OriginatorIdentifierOrKey b;
    private ASN1OctetString c;
    private AlgorithmIdentifier d;
    private ASN1Sequence e;

    public KeyAgreeRecipientInfo(OriginatorIdentifierOrKey originator, ASN1OctetString ukm, AlgorithmIdentifier keyEncryptionAlgorithm, ASN1Sequence recipientEncryptedKeys) {
        this.a = new ASN1Integer(3L);
        this.b = originator;
        this.c = ukm;
        this.d = keyEncryptionAlgorithm;
        this.e = recipientEncryptedKeys;
    }

    public KeyAgreeRecipientInfo(ASN1Sequence seq) {
        int n2 = 0;
        this.a = (ASN1Integer)seq.getObjectAt(n2++);
        this.b = OriginatorIdentifierOrKey.getInstance((ASN1TaggedObject)seq.getObjectAt(n2++), true);
        if (seq.getObjectAt(n2) instanceof ASN1TaggedObject) {
            this.c = ASN1OctetString.getInstance((ASN1TaggedObject)seq.getObjectAt(n2++), true);
        }
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2++));
        this.e = (ASN1Sequence)seq.getObjectAt(n2++);
    }

    public static KeyAgreeRecipientInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return KeyAgreeRecipientInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static KeyAgreeRecipientInfo getInstance(Object obj) {
        if (obj instanceof KeyAgreeRecipientInfo) {
            return (KeyAgreeRecipientInfo)obj;
        }
        if (obj != null) {
            return new KeyAgreeRecipientInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.b;
    }

    public ASN1OctetString getUserKeyingMaterial() {
        return this.c;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.d;
    }

    public ASN1Sequence getRecipientEncryptedKeys() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.b));
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.c));
        }
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        return new DERSequence(aSN1EncodableVector);
    }
}

