/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.IssuerAndSerialNumber;

public class RecipientIdentifier
extends ASN1Object
implements ASN1Choice {
    private ASN1Encodable a;

    public RecipientIdentifier(IssuerAndSerialNumber id) {
        this.a = id;
    }

    public RecipientIdentifier(ASN1OctetString id) {
        this.a = new DERTaggedObject(false, 0, id);
    }

    public RecipientIdentifier(ASN1Primitive id) {
        this.a = id;
    }

    public static RecipientIdentifier getInstance(Object o2) {
        if (o2 == null || o2 instanceof RecipientIdentifier) {
            return (RecipientIdentifier)o2;
        }
        if (o2 instanceof IssuerAndSerialNumber) {
            return new RecipientIdentifier((IssuerAndSerialNumber)o2);
        }
        if (o2 instanceof ASN1OctetString) {
            return new RecipientIdentifier((ASN1OctetString)o2);
        }
        if (o2 instanceof ASN1Primitive) {
            return new RecipientIdentifier((ASN1Primitive)o2);
        }
        throw new IllegalArgumentException("Illegal object in RecipientIdentifier: " + o2.getClass().getName());
    }

    public boolean isTagged() {
        return this.a instanceof ASN1TaggedObject;
    }

    public ASN1Encodable getId() {
        if (this.a instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance((ASN1TaggedObject)this.a, false);
        }
        return IssuerAndSerialNumber.getInstance(this.a);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a.toASN1Primitive();
    }
}

