/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cms.KEKRecipientInfo;
import com.enterprisedt.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import com.enterprisedt.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import com.enterprisedt.bouncycastle.asn1.cms.OtherRecipientInfo;
import com.enterprisedt.bouncycastle.asn1.cms.PasswordRecipientInfo;

public class RecipientInfo
extends ASN1Object
implements ASN1Choice {
    ASN1Encodable a;

    public RecipientInfo(KeyTransRecipientInfo info) {
        this.a = info;
    }

    public RecipientInfo(KeyAgreeRecipientInfo info) {
        this.a = new DERTaggedObject(false, 1, info);
    }

    public RecipientInfo(KEKRecipientInfo info) {
        this.a = new DERTaggedObject(false, 2, info);
    }

    public RecipientInfo(PasswordRecipientInfo info) {
        this.a = new DERTaggedObject(false, 3, info);
    }

    public RecipientInfo(OtherRecipientInfo info) {
        this.a = new DERTaggedObject(false, 4, info);
    }

    public RecipientInfo(ASN1Primitive info) {
        this.a = info;
    }

    public static RecipientInfo getInstance(Object o2) {
        if (o2 == null || o2 instanceof RecipientInfo) {
            return (RecipientInfo)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new RecipientInfo((ASN1Sequence)o2);
        }
        if (o2 instanceof ASN1TaggedObject) {
            return new RecipientInfo((ASN1TaggedObject)o2);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o2.getClass().getName());
    }

    public ASN1Integer getVersion() {
        if (this.a instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.a;
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, false).getVersion();
                }
                case 2: {
                    return this.a(aSN1TaggedObject).getVersion();
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(aSN1TaggedObject, false).getVersion();
                }
                case 4: {
                    return new ASN1Integer(0L);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.a).getVersion();
    }

    public boolean isTagged() {
        return this.a instanceof ASN1TaggedObject;
    }

    public ASN1Encodable getInfo() {
        if (this.a instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.a;
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
                case 2: {
                    return this.a(aSN1TaggedObject);
                }
                case 3: {
                    return PasswordRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
                case 4: {
                    return OtherRecipientInfo.getInstance(aSN1TaggedObject, false);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.a);
    }

    private KEKRecipientInfo a(ASN1TaggedObject aSN1TaggedObject) {
        if (aSN1TaggedObject.isExplicit()) {
            return KEKRecipientInfo.getInstance(aSN1TaggedObject, true);
        }
        return KEKRecipientInfo.getInstance(aSN1TaggedObject, false);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a.toASN1Primitive();
    }
}

