/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cms;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cms.OtherKeyAttribute;

public class RecipientKeyIdentifier
extends ASN1Object {
    private ASN1OctetString a;
    private ASN1GeneralizedTime b;
    private OtherKeyAttribute c;

    public RecipientKeyIdentifier(ASN1OctetString subjectKeyIdentifier, ASN1GeneralizedTime date, OtherKeyAttribute other) {
        this.a = subjectKeyIdentifier;
        this.b = date;
        this.c = other;
    }

    public RecipientKeyIdentifier(byte[] subjectKeyIdentifier, ASN1GeneralizedTime date, OtherKeyAttribute other) {
        this.a = new DEROctetString(subjectKeyIdentifier);
        this.b = date;
        this.c = other;
    }

    public RecipientKeyIdentifier(byte[] subjectKeyIdentifier) {
        this(subjectKeyIdentifier, null, null);
    }

    public RecipientKeyIdentifier(ASN1Sequence seq) {
        this.a = ASN1OctetString.getInstance(seq.getObjectAt(0));
        switch (seq.size()) {
            case 1: {
                break;
            }
            case 2: {
                if (seq.getObjectAt(1) instanceof ASN1GeneralizedTime) {
                    this.b = ASN1GeneralizedTime.getInstance(seq.getObjectAt(1));
                    break;
                }
                this.c = OtherKeyAttribute.getInstance(seq.getObjectAt(2));
                break;
            }
            case 3: {
                this.b = ASN1GeneralizedTime.getInstance(seq.getObjectAt(1));
                this.c = OtherKeyAttribute.getInstance(seq.getObjectAt(2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid RecipientKeyIdentifier");
            }
        }
    }

    public static RecipientKeyIdentifier getInstance(ASN1TaggedObject ato, boolean isExplicit) {
        return RecipientKeyIdentifier.getInstance(ASN1Sequence.getInstance(ato, isExplicit));
    }

    public static RecipientKeyIdentifier getInstance(Object obj) {
        if (obj instanceof RecipientKeyIdentifier) {
            return (RecipientKeyIdentifier)obj;
        }
        if (obj != null) {
            return new RecipientKeyIdentifier(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1OctetString getSubjectKeyIdentifier() {
        return this.a;
    }

    public ASN1GeneralizedTime getDate() {
        return this.b;
    }

    public OtherKeyAttribute getOtherKeyAttribute() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

