/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import java.math.BigInteger;

public class CertId
extends ASN1Object {
    private GeneralName a;
    private ASN1Integer b;

    private CertId(ASN1Sequence seq) {
        this.a = GeneralName.getInstance(seq.getObjectAt(0));
        this.b = ASN1Integer.getInstance(seq.getObjectAt(1));
    }

    public static CertId getInstance(Object o2) {
        if (o2 instanceof CertId) {
            return (CertId)o2;
        }
        if (o2 != null) {
            return new CertId(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public static CertId getInstance(ASN1TaggedObject obj, boolean isExplicit) {
        return CertId.getInstance(ASN1Sequence.getInstance(obj, isExplicit));
    }

    public CertId(GeneralName issuer, BigInteger serialNumber) {
        this(issuer, new ASN1Integer(serialNumber));
    }

    public CertId(GeneralName issuer, ASN1Integer serialNumber) {
        this.a = issuer;
        this.b = serialNumber;
    }

    public GeneralName getIssuer() {
        return this.a;
    }

    public ASN1Integer getSerialNumber() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

