/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.crmf.CertTemplate;
import com.enterprisedt.bouncycastle.asn1.crmf.Controls;

public class CertRequest
extends ASN1Object {
    private ASN1Integer a;
    private CertTemplate b;
    private Controls c;

    private CertRequest(ASN1Sequence seq) {
        this.a = new ASN1Integer(ASN1Integer.getInstance(seq.getObjectAt(0)).getValue());
        this.b = CertTemplate.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.c = Controls.getInstance(seq.getObjectAt(2));
        }
    }

    public static CertRequest getInstance(Object o2) {
        if (o2 instanceof CertRequest) {
            return (CertRequest)o2;
        }
        if (o2 != null) {
            return new CertRequest(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CertRequest(int certReqId, CertTemplate certTemplate, Controls controls) {
        this(new ASN1Integer(certReqId), certTemplate, controls);
    }

    public CertRequest(ASN1Integer certReqId, CertTemplate certTemplate, Controls controls) {
        this.a = certReqId;
        this.b = certTemplate;
        this.c = controls;
    }

    public ASN1Integer getCertReqId() {
        return this.a;
    }

    public CertTemplate getCertTemplate() {
        return this.b;
    }

    public Controls getControls() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

