/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.crmf.CertTemplate;
import com.enterprisedt.bouncycastle.asn1.crmf.OptionalValidity;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;

public class CertTemplateBuilder {
    private ASN1Integer a;
    private ASN1Integer b;
    private AlgorithmIdentifier c;
    private X500Name d;
    private OptionalValidity e;
    private X500Name f;
    private SubjectPublicKeyInfo g;
    private DERBitString h;
    private DERBitString i;
    private Extensions j;

    public CertTemplateBuilder setVersion(int ver) {
        this.a = new ASN1Integer(ver);
        return this;
    }

    public CertTemplateBuilder setSerialNumber(ASN1Integer ser) {
        this.b = ser;
        return this;
    }

    public CertTemplateBuilder setSigningAlg(AlgorithmIdentifier aid) {
        this.c = aid;
        return this;
    }

    public CertTemplateBuilder setIssuer(X500Name name) {
        this.d = name;
        return this;
    }

    public CertTemplateBuilder setValidity(OptionalValidity v2) {
        this.e = v2;
        return this;
    }

    public CertTemplateBuilder setSubject(X500Name name) {
        this.f = name;
        return this;
    }

    public CertTemplateBuilder setPublicKey(SubjectPublicKeyInfo spki) {
        this.g = spki;
        return this;
    }

    public CertTemplateBuilder setIssuerUID(DERBitString uid) {
        this.h = uid;
        return this;
    }

    public CertTemplateBuilder setSubjectUID(DERBitString uid) {
        this.i = uid;
        return this;
    }

    public CertTemplateBuilder setExtensions(X509Extensions extens) {
        return this.setExtensions(Extensions.getInstance(extens));
    }

    public CertTemplateBuilder setExtensions(Extensions extens) {
        this.j = extens;
        return this;
    }

    public CertTemplate build() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.a(aSN1EncodableVector, 0, false, this.a);
        this.a(aSN1EncodableVector, 1, false, this.b);
        this.a(aSN1EncodableVector, 2, false, this.c);
        this.a(aSN1EncodableVector, 3, true, this.d);
        this.a(aSN1EncodableVector, 4, false, this.e);
        this.a(aSN1EncodableVector, 5, true, this.f);
        this.a(aSN1EncodableVector, 6, false, this.g);
        this.a(aSN1EncodableVector, 7, false, this.h);
        this.a(aSN1EncodableVector, 8, false, this.i);
        this.a(aSN1EncodableVector, 9, false, this.j);
        return CertTemplate.getInstance(new DERSequence(aSN1EncodableVector));
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, boolean bl, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(bl, n2, aSN1Encodable));
        }
    }
}

