/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedValue
extends ASN1Object {
    private AlgorithmIdentifier a;
    private AlgorithmIdentifier b;
    private DERBitString c;
    private AlgorithmIdentifier d;
    private ASN1OctetString e;
    private DERBitString f;

    private EncryptedValue(ASN1Sequence seq) {
        int n2 = 0;
        while (seq.getObjectAt(n2) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(n2);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.a = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 1: {
                    this.b = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 2: {
                    this.c = DERBitString.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 3: {
                    this.d = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 4: {
                    this.e = ASN1OctetString.getInstance(aSN1TaggedObject, false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag encountered: " + aSN1TaggedObject.getTagNo());
                }
            }
            ++n2;
        }
        this.f = DERBitString.getInstance(seq.getObjectAt(n2));
    }

    public static EncryptedValue getInstance(Object o2) {
        if (o2 instanceof EncryptedValue) {
            return (EncryptedValue)o2;
        }
        if (o2 != null) {
            return new EncryptedValue(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public EncryptedValue(AlgorithmIdentifier intendedAlg, AlgorithmIdentifier symmAlg, DERBitString encSymmKey, AlgorithmIdentifier keyAlg, ASN1OctetString valueHint, DERBitString encValue) {
        if (encValue == null) {
            throw new IllegalArgumentException("'encValue' cannot be null");
        }
        this.a = intendedAlg;
        this.b = symmAlg;
        this.c = encSymmKey;
        this.d = keyAlg;
        this.e = valueHint;
        this.f = encValue;
    }

    public AlgorithmIdentifier getIntendedAlg() {
        return this.a;
    }

    public AlgorithmIdentifier getSymmAlg() {
        return this.b;
    }

    public DERBitString getEncSymmKey() {
        return this.c;
    }

    public AlgorithmIdentifier getKeyAlg() {
        return this.d;
    }

    public ASN1OctetString getValueHint() {
        return this.e;
    }

    public DERBitString getEncValue() {
        return this.f;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        this.a(aSN1EncodableVector, 0, this.a);
        this.a(aSN1EncodableVector, 1, this.b);
        this.a(aSN1EncodableVector, 2, this.c);
        this.a(aSN1EncodableVector, 3, this.d);
        this.a(aSN1EncodableVector, 4, this.e);
        aSN1EncodableVector.add(this.f);
        return new DERSequence(aSN1EncodableVector);
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, n2, aSN1Encodable));
        }
    }
}

