/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.crmf;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.crmf.PKMACValue;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class POPOSigningKeyInput
extends ASN1Object {
    private GeneralName a;
    private PKMACValue b;
    private SubjectPublicKeyInfo c;

    private POPOSigningKeyInput(ASN1Sequence seq) {
        ASN1Encodable aSN1Encodable = seq.getObjectAt(0);
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable;
            if (aSN1TaggedObject.getTagNo() != 0) {
                throw new IllegalArgumentException("Unknown authInfo tag: " + aSN1TaggedObject.getTagNo());
            }
            this.a = GeneralName.getInstance(aSN1TaggedObject.getObject());
        } else {
            this.b = PKMACValue.getInstance(aSN1Encodable);
        }
        this.c = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(1));
    }

    public static POPOSigningKeyInput getInstance(Object o2) {
        if (o2 instanceof POPOSigningKeyInput) {
            return (POPOSigningKeyInput)o2;
        }
        if (o2 != null) {
            return new POPOSigningKeyInput(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public POPOSigningKeyInput(GeneralName sender, SubjectPublicKeyInfo spki) {
        this.a = sender;
        this.c = spki;
    }

    public POPOSigningKeyInput(PKMACValue pkmac, SubjectPublicKeyInfo spki) {
        this.b = pkmac;
        this.c = spki;
    }

    public GeneralName getSender() {
        return this.a;
    }

    public PKMACValue getPublicKeyMAC() {
        return this.b;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
        } else {
            aSN1EncodableVector.add(this.b);
        }
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

