/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cryptopro;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class ECGOST3410ParamSetParameters
extends ASN1Object {
    ASN1Integer a;
    ASN1Integer b;
    ASN1Integer c;
    ASN1Integer d;
    ASN1Integer e;
    ASN1Integer f;

    public static ECGOST3410ParamSetParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ECGOST3410ParamSetParameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static ECGOST3410ParamSetParameters getInstance(Object obj) {
        if (obj == null || obj instanceof ECGOST3410ParamSetParameters) {
            return (ECGOST3410ParamSetParameters)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ECGOST3410ParamSetParameters((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid GOST3410Parameter: " + obj.getClass().getName());
    }

    public ECGOST3410ParamSetParameters(BigInteger a2, BigInteger b2, BigInteger p2, BigInteger q2, int x2, BigInteger y2) {
        this.c = new ASN1Integer(a2);
        this.d = new ASN1Integer(b2);
        this.a = new ASN1Integer(p2);
        this.b = new ASN1Integer(q2);
        this.e = new ASN1Integer(x2);
        this.f = new ASN1Integer(y2);
    }

    public ECGOST3410ParamSetParameters(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.c = (ASN1Integer)enumeration.nextElement();
        this.d = (ASN1Integer)enumeration.nextElement();
        this.a = (ASN1Integer)enumeration.nextElement();
        this.b = (ASN1Integer)enumeration.nextElement();
        this.e = (ASN1Integer)enumeration.nextElement();
        this.f = (ASN1Integer)enumeration.nextElement();
    }

    public BigInteger getP() {
        return this.a.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.b.getPositiveValue();
    }

    public BigInteger getA() {
        return this.c.getPositiveValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        return new DERSequence(aSN1EncodableVector);
    }
}

