/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cryptopro;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Gost2814789EncryptedKey
extends ASN1Object {
    private final byte[] a;
    private final byte[] b;
    private final byte[] c;

    private Gost2814789EncryptedKey(ASN1Sequence seq) {
        if (seq.size() == 2) {
            this.a = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
            this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
            this.b = null;
        } else if (seq.size() == 3) {
            this.a = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
            this.b = Arrays.clone(ASN1OctetString.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(1)), false).getOctets());
            this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        } else {
            throw new IllegalArgumentException("unknown sequence length: " + seq.size());
        }
    }

    public static Gost2814789EncryptedKey getInstance(Object obj) {
        if (obj instanceof Gost2814789EncryptedKey) {
            return (Gost2814789EncryptedKey)obj;
        }
        if (obj != null) {
            return new Gost2814789EncryptedKey(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public Gost2814789EncryptedKey(byte[] encryptedKey, byte[] macKey) {
        this(encryptedKey, null, macKey);
    }

    public Gost2814789EncryptedKey(byte[] encryptedKey, byte[] maskKey, byte[] macKey) {
        this.a = Arrays.clone(encryptedKey);
        this.b = Arrays.clone(maskKey);
        this.c = Arrays.clone(macKey);
    }

    public byte[] getEncryptedKey() {
        return this.a;
    }

    public byte[] getMaskKey() {
        return this.b;
    }

    public byte[] getMacKey() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DEROctetString(this.a));
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, new DEROctetString(this.a)));
        }
        aSN1EncodableVector.add(new DEROctetString(this.c));
        return new DERSequence(aSN1EncodableVector);
    }
}

