/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.enterprisedt.bouncycastle.asn1.cms.ContentInfo;
import com.enterprisedt.bouncycastle.asn1.ess.ESSCertID;
import com.enterprisedt.bouncycastle.asn1.ocsp.CertID;
import com.enterprisedt.bouncycastle.asn1.ocsp.CertStatus;
import com.enterprisedt.bouncycastle.asn1.ocsp.OCSPResponse;
import com.enterprisedt.bouncycastle.asn1.smime.SMIMECapabilities;
import com.enterprisedt.bouncycastle.asn1.x509.Certificate;
import com.enterprisedt.bouncycastle.asn1.x509.CertificateList;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;

public class CertEtcToken
extends ASN1Object
implements ASN1Choice {
    public static final int TAG_CERTIFICATE = 0;
    public static final int TAG_ESSCERTID = 1;
    public static final int TAG_PKISTATUS = 2;
    public static final int TAG_ASSERTION = 3;
    public static final int TAG_CRL = 4;
    public static final int TAG_OCSPCERTSTATUS = 5;
    public static final int TAG_OCSPCERTID = 6;
    public static final int TAG_OCSPRESPONSE = 7;
    public static final int TAG_CAPABILITIES = 8;
    private static final boolean[] a = new boolean[]{false, true, false, true, false, true, false, false, true};
    private int b;
    private ASN1Encodable c;
    private Extension d;

    public CertEtcToken(int tagNo, ASN1Encodable value) {
        this.b = tagNo;
        this.c = value;
    }

    public CertEtcToken(Extension extension) {
        this.b = -1;
        this.d = extension;
    }

    private CertEtcToken(ASN1TaggedObject choice) {
        this.b = choice.getTagNo();
        switch (this.b) {
            case 0: {
                this.c = Certificate.getInstance(choice, false);
                break;
            }
            case 1: {
                this.c = ESSCertID.getInstance(choice.getObject());
                break;
            }
            case 2: {
                this.c = PKIStatusInfo.getInstance(choice, false);
                break;
            }
            case 3: {
                this.c = ContentInfo.getInstance(choice.getObject());
                break;
            }
            case 4: {
                this.c = CertificateList.getInstance(choice, false);
                break;
            }
            case 5: {
                this.c = CertStatus.getInstance(choice.getObject());
                break;
            }
            case 6: {
                this.c = CertID.getInstance(choice, false);
                break;
            }
            case 7: {
                this.c = OCSPResponse.getInstance(choice, false);
                break;
            }
            case 8: {
                this.c = SMIMECapabilities.getInstance(choice.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tag: " + this.b);
            }
        }
    }

    public static CertEtcToken getInstance(Object obj) {
        if (obj instanceof CertEtcToken) {
            return (CertEtcToken)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new CertEtcToken((ASN1TaggedObject)obj);
        }
        if (obj != null) {
            return new CertEtcToken(Extension.getInstance(obj));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.d == null) {
            return new DERTaggedObject(a[this.b], this.b, this.c);
        }
        return this.d.toASN1Primitive();
    }

    public int getTagNo() {
        return this.b;
    }

    public ASN1Encodable getValue() {
        return this.c;
    }

    public Extension getExtension() {
        return this.d;
    }

    public String toString() {
        return "CertEtcToken {\n" + this.c + "}\n";
    }

    public static CertEtcToken[] arrayFromSequence(ASN1Sequence seq) {
        CertEtcToken[] certEtcTokenArray = new CertEtcToken[seq.size()];
        for (int i2 = 0; i2 != certEtcTokenArray.length; ++i2) {
            certEtcTokenArray[i2] = CertEtcToken.getInstance(seq.getObjectAt(i2));
        }
        return certEtcTokenArray;
    }
}

