/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSTime;
import com.enterprisedt.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.enterprisedt.bouncycastle.asn1.x509.DigestInfo;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.PolicyInformation;

public class DVCSCertInfo
extends ASN1Object {
    private int a = 1;
    private DVCSRequestInformation b;
    private DigestInfo c;
    private ASN1Integer d;
    private DVCSTime e;
    private PKIStatusInfo f;
    private PolicyInformation g;
    private ASN1Set h;
    private ASN1Sequence i;
    private Extensions j;

    public DVCSCertInfo(DVCSRequestInformation dvReqInfo, DigestInfo messageImprint, ASN1Integer serialNumber, DVCSTime responseTime) {
        this.b = dvReqInfo;
        this.c = messageImprint;
        this.d = serialNumber;
        this.e = responseTime;
    }

    private DVCSCertInfo(ASN1Sequence seq) {
        ASN1Primitive aSN1Primitive;
        int n2 = 0;
        ASN1Encodable aSN1Encodable = seq.getObjectAt(n2++);
        try {
            aSN1Primitive = ASN1Integer.getInstance(aSN1Encodable);
            this.a = ((ASN1Integer)aSN1Primitive).getValue().intValue();
            aSN1Encodable = seq.getObjectAt(n2++);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.b = DVCSRequestInformation.getInstance(aSN1Encodable);
        aSN1Encodable = seq.getObjectAt(n2++);
        this.c = DigestInfo.getInstance(aSN1Encodable);
        aSN1Encodable = seq.getObjectAt(n2++);
        this.d = ASN1Integer.getInstance(aSN1Encodable);
        aSN1Encodable = seq.getObjectAt(n2++);
        this.e = DVCSTime.getInstance(aSN1Encodable);
        block10: while (n2 < seq.size()) {
            if ((aSN1Encodable = seq.getObjectAt(n2++)) instanceof ASN1TaggedObject) {
                aSN1Primitive = ASN1TaggedObject.getInstance(aSN1Encodable);
                int n3 = ((ASN1TaggedObject)aSN1Primitive).getTagNo();
                switch (n3) {
                    case 0: {
                        this.f = PKIStatusInfo.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        continue block10;
                    }
                    case 1: {
                        this.g = PolicyInformation.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Primitive, false));
                        continue block10;
                    }
                    case 2: {
                        this.h = ASN1Set.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        continue block10;
                    }
                    case 3: {
                        this.i = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Primitive, false);
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unknown tag encountered: " + n3);
            }
            try {
                this.j = Extensions.getInstance(aSN1Encodable);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public static DVCSCertInfo getInstance(Object obj) {
        if (obj instanceof DVCSCertInfo) {
            return (DVCSCertInfo)obj;
        }
        if (obj != null) {
            return new DVCSCertInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static DVCSCertInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DVCSCertInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != 1) {
            aSN1EncodableVector.add(new ASN1Integer(this.a));
        }
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        if (this.f != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.f));
        }
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.g));
        }
        if (this.h != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.h));
        }
        if (this.i != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, this.i));
        }
        if (this.j != null) {
            aSN1EncodableVector.add(this.j);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DVCSCertInfo {\n");
        if (this.a != 1) {
            stringBuffer.append("version: " + this.a + "\n");
        }
        stringBuffer.append("dvReqInfo: " + this.b + "\n");
        stringBuffer.append("messageImprint: " + this.c + "\n");
        stringBuffer.append("serialNumber: " + this.d + "\n");
        stringBuffer.append("responseTime: " + this.e + "\n");
        if (this.f != null) {
            stringBuffer.append("dvStatus: " + this.f + "\n");
        }
        if (this.g != null) {
            stringBuffer.append("policy: " + this.g + "\n");
        }
        if (this.h != null) {
            stringBuffer.append("reqSignature: " + this.h + "\n");
        }
        if (this.i != null) {
            stringBuffer.append("certs: " + this.i + "\n");
        }
        if (this.j != null) {
            stringBuffer.append("extensions: " + this.j + "\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public int getVersion() {
        return this.a;
    }

    public DVCSRequestInformation getDvReqInfo() {
        return this.b;
    }

    public DigestInfo getMessageImprint() {
        return this.c;
    }

    public ASN1Integer getSerialNumber() {
        return this.d;
    }

    public DVCSTime getResponseTime() {
        return this.e;
    }

    public PKIStatusInfo getDvStatus() {
        return this.f;
    }

    public PolicyInformation getPolicy() {
        return this.g;
    }

    public ASN1Set getReqSignature() {
        return this.h;
    }

    public TargetEtcChain[] getCerts() {
        if (this.i != null) {
            return TargetEtcChain.arrayFromSequence(this.i);
        }
        return null;
    }

    public Extensions getExtensions() {
        return this.j;
    }
}

