/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSCertInfo;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSTime;
import com.enterprisedt.bouncycastle.asn1.dvcs.TargetEtcChain;
import com.enterprisedt.bouncycastle.asn1.x509.DigestInfo;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.PolicyInformation;

public class DVCSCertInfoBuilder {
    private int a = 1;
    private DVCSRequestInformation b;
    private DigestInfo c;
    private ASN1Integer d;
    private DVCSTime e;
    private PKIStatusInfo f;
    private PolicyInformation g;
    private ASN1Set h;
    private ASN1Sequence i;
    private Extensions j;

    public DVCSCertInfoBuilder(DVCSRequestInformation dvReqInfo, DigestInfo messageImprint, ASN1Integer serialNumber, DVCSTime responseTime) {
        this.b = dvReqInfo;
        this.c = messageImprint;
        this.d = serialNumber;
        this.e = responseTime;
    }

    public DVCSCertInfo build() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != 1) {
            aSN1EncodableVector.add(new ASN1Integer(this.a));
        }
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        if (this.f != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.f));
        }
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.g));
        }
        if (this.h != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, this.h));
        }
        if (this.i != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 3, this.i));
        }
        if (this.j != null) {
            aSN1EncodableVector.add(this.j);
        }
        return DVCSCertInfo.getInstance(new DERSequence(aSN1EncodableVector));
    }

    public void setVersion(int version) {
        this.a = version;
    }

    public void setDvReqInfo(DVCSRequestInformation dvReqInfo) {
        this.b = dvReqInfo;
    }

    public void setMessageImprint(DigestInfo messageImprint) {
        this.c = messageImprint;
    }

    public void setSerialNumber(ASN1Integer serialNumber) {
        this.d = serialNumber;
    }

    public void setResponseTime(DVCSTime responseTime) {
        this.e = responseTime;
    }

    public void setDvStatus(PKIStatusInfo dvStatus) {
        this.f = dvStatus;
    }

    public void setPolicy(PolicyInformation policy) {
        this.g = policy;
    }

    public void setReqSignature(ASN1Set reqSignature) {
        this.h = reqSignature;
    }

    public void setCerts(TargetEtcChain[] certs) {
        this.i = new DERSequence(certs);
    }

    public void setExtensions(Extensions extensions) {
        this.j = extensions;
    }
}

