/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.cmp.PKIStatusInfo;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;

public class DVCSErrorNotice
extends ASN1Object {
    private PKIStatusInfo a;
    private GeneralName b;

    public DVCSErrorNotice(PKIStatusInfo status) {
        this(status, null);
    }

    public DVCSErrorNotice(PKIStatusInfo status, GeneralName transactionIdentifier) {
        this.a = status;
        this.b = transactionIdentifier;
    }

    private DVCSErrorNotice(ASN1Sequence seq) {
        this.a = PKIStatusInfo.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.b = GeneralName.getInstance(seq.getObjectAt(1));
        }
    }

    public static DVCSErrorNotice getInstance(Object obj) {
        if (obj instanceof DVCSErrorNotice) {
            return (DVCSErrorNotice)obj;
        }
        if (obj != null) {
            return new DVCSErrorNotice(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static DVCSErrorNotice getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DVCSErrorNotice.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        return "DVCSErrorNotice {\ntransactionStatus: " + this.a + "\n" + (this.b != null ? "transactionIdentifier: " + this.b + "\n" : "") + "}\n";
    }

    public PKIStatusInfo getTransactionStatus() {
        return this.a;
    }

    public GeneralName getTransactionIdentifier() {
        return this.b;
    }
}

