/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSRequestInformation;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSTime;
import com.enterprisedt.bouncycastle.asn1.dvcs.ServiceType;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;
import com.enterprisedt.bouncycastle.asn1.x509.PolicyInformation;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.math.BigInteger;

public class DVCSRequestInformationBuilder {
    private int a = 1;
    private final ServiceType b;
    private DVCSRequestInformation c;
    private BigInteger d;
    private DVCSTime e;
    private GeneralNames f;
    private PolicyInformation g;
    private GeneralNames h;
    private GeneralNames i;
    private Extensions j;

    public DVCSRequestInformationBuilder(ServiceType service) {
        this.b = service;
    }

    public DVCSRequestInformationBuilder(DVCSRequestInformation initialInfo) {
        this.c = initialInfo;
        this.b = initialInfo.getService();
        this.a = initialInfo.getVersion();
        this.d = initialInfo.getNonce();
        this.e = initialInfo.getRequestTime();
        this.g = initialInfo.getRequestPolicy();
        this.h = initialInfo.getDVCS();
        this.i = initialInfo.getDataLocations();
    }

    public DVCSRequestInformation build() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != 1) {
            aSN1EncodableVector.add(new ASN1Integer(this.a));
        }
        aSN1EncodableVector.add(this.b);
        if (this.d != null) {
            aSN1EncodableVector.add(new ASN1Integer(this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        int[] nArray = new int[]{0, 1, 2, 3, 4};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{this.f, this.g, this.h, this.i, this.j};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            ASN1Encodable aSN1Encodable = aSN1EncodableArray[i2];
            if (aSN1Encodable == null) continue;
            aSN1EncodableVector.add(new DERTaggedObject(false, n2, aSN1Encodable));
        }
        return DVCSRequestInformation.getInstance(new DERSequence(aSN1EncodableVector));
    }

    public void setVersion(int version) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change version in existing DVCSRequestInformation");
        }
        this.a = version;
    }

    public void setNonce(BigInteger nonce) {
        if (this.c != null) {
            if (this.c.getNonce() == null) {
                this.d = nonce;
            } else {
                byte[] byArray = this.c.getNonce().toByteArray();
                byte[] byArray2 = BigIntegers.asUnsignedByteArray(nonce);
                byte[] byArray3 = new byte[byArray.length + byArray2.length];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                this.d = new BigInteger(byArray3);
            }
        }
        this.d = nonce;
    }

    public void setRequestTime(DVCSTime requestTime) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change request time in existing DVCSRequestInformation");
        }
        this.e = requestTime;
    }

    public void setRequester(GeneralName requester) {
        this.setRequester(new GeneralNames(requester));
    }

    public void setRequester(GeneralNames requester) {
        this.f = requester;
    }

    public void setRequestPolicy(PolicyInformation requestPolicy) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change request policy in existing DVCSRequestInformation");
        }
        this.g = requestPolicy;
    }

    public void setDVCS(GeneralName dvcs) {
        this.setDVCS(new GeneralNames(dvcs));
    }

    public void setDVCS(GeneralNames dvcs) {
        this.h = dvcs;
    }

    public void setDataLocations(GeneralName dataLocation) {
        this.setDataLocations(new GeneralNames(dataLocation));
    }

    public void setDataLocations(GeneralNames dataLocations) {
        this.i = dataLocations;
    }

    public void setExtensions(Extensions extensions) {
        if (this.c != null) {
            throw new IllegalStateException("cannot change extensions in existing DVCSRequestInformation");
        }
        this.j = extensions;
    }
}

