/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.dvcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSCertInfo;
import com.enterprisedt.bouncycastle.asn1.dvcs.DVCSErrorNotice;
import java.io.IOException;

public class DVCSResponse
extends ASN1Object
implements ASN1Choice {
    private DVCSCertInfo a;
    private DVCSErrorNotice b;

    public DVCSResponse(DVCSCertInfo dvCertInfo) {
        this.a = dvCertInfo;
    }

    public DVCSResponse(DVCSErrorNotice dvErrorNote) {
        this.b = dvErrorNote;
    }

    public static DVCSResponse getInstance(Object obj) {
        if (obj == null || obj instanceof DVCSResponse) {
            return (DVCSResponse)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return DVCSResponse.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + iOException.getMessage());
            }
        }
        if (obj instanceof ASN1Sequence) {
            DVCSCertInfo dVCSCertInfo = DVCSCertInfo.getInstance(obj);
            return new DVCSResponse(dVCSCertInfo);
        }
        if (obj instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(obj);
            DVCSErrorNotice dVCSErrorNotice = DVCSErrorNotice.getInstance(aSN1TaggedObject, false);
            return new DVCSResponse(dVCSErrorNotice);
        }
        throw new IllegalArgumentException("Couldn't convert from object to DVCSResponse: " + obj.getClass().getName());
    }

    public static DVCSResponse getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DVCSResponse.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public DVCSCertInfo getCertInfo() {
        return this.a;
    }

    public DVCSErrorNotice getErrorNotice() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, this.b);
    }

    public String toString() {
        if (this.a != null) {
            return "DVCSResponse {\ndvCertInfo: " + this.a.toString() + "}\n";
        }
        return "DVCSResponse {\ndvErrorNote: " + this.b.toString() + "}\n";
    }
}

