/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.eac;

import com.enterprisedt.bouncycastle.asn1.ASN1ApplicationSpecific;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERApplicationSpecific;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateBody;
import com.enterprisedt.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Enumeration;

public class CVCertificateRequest
extends ASN1Object {
    private final ASN1ApplicationSpecific a;
    private CertificateBody b;
    private byte[] c = null;
    private byte[] d = null;

    private CVCertificateRequest(ASN1ApplicationSpecific request) throws IOException {
        this.a = request;
        if (request.isConstructed() && request.getApplicationTag() == 7) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(request.getObject(16));
            this.a(ASN1ApplicationSpecific.getInstance(aSN1Sequence.getObjectAt(0)));
            this.d = ASN1ApplicationSpecific.getInstance(aSN1Sequence.getObjectAt(aSN1Sequence.size() - 1)).getContents();
        } else {
            this.a(request);
        }
    }

    private void a(ASN1ApplicationSpecific aSN1ApplicationSpecific) throws IOException {
        if (aSN1ApplicationSpecific.getApplicationTag() == 33) {
            int n2 = 0;
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1ApplicationSpecific.getObject(16));
            Enumeration enumeration = aSN1Sequence.getObjects();
            block4: while (enumeration.hasMoreElements()) {
                ASN1ApplicationSpecific aSN1ApplicationSpecific2 = ASN1ApplicationSpecific.getInstance(enumeration.nextElement());
                switch (aSN1ApplicationSpecific2.getApplicationTag()) {
                    case 78: {
                        this.b = CertificateBody.getInstance(aSN1ApplicationSpecific2);
                        n2 |= 1;
                        continue block4;
                    }
                    case 55: {
                        this.c = aSN1ApplicationSpecific2.getContents();
                        n2 |= 2;
                        continue block4;
                    }
                }
                throw new IOException("Invalid tag, not an CV Certificate Request element:" + aSN1ApplicationSpecific2.getApplicationTag());
            }
            if ((n2 & 3) == 0) {
                throw new IOException("Invalid CARDHOLDER_CERTIFICATE in request:" + aSN1ApplicationSpecific.getApplicationTag());
            }
        } else {
            throw new IOException("not a CARDHOLDER_CERTIFICATE in request:" + aSN1ApplicationSpecific.getApplicationTag());
        }
    }

    public static CVCertificateRequest getInstance(Object obj) {
        if (obj instanceof CVCertificateRequest) {
            return (CVCertificateRequest)obj;
        }
        if (obj != null) {
            try {
                return new CVCertificateRequest(ASN1ApplicationSpecific.getInstance(obj));
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("unable to parse data: " + iOException.getMessage(), iOException);
            }
        }
        return null;
    }

    public CertificateBody getCertificateBody() {
        return this.b;
    }

    public PublicKeyDataObject getPublicKey() {
        return this.b.getPublicKey();
    }

    public byte[] getInnerSignature() {
        return Arrays.clone(this.c);
    }

    public byte[] getOuterSignature() {
        return Arrays.clone(this.d);
    }

    public boolean hasOuterSignature() {
        return this.d != null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        try {
            aSN1EncodableVector.add(new DERApplicationSpecific(false, 55, new DEROctetString(this.c)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to convert signature!");
        }
        return new DERApplicationSpecific(33, aSN1EncodableVector);
    }
}

