/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ess;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;

public class ContentHints
extends ASN1Object {
    private DERUTF8String a;
    private ASN1ObjectIdentifier b;

    public static ContentHints getInstance(Object o2) {
        if (o2 instanceof ContentHints) {
            return (ContentHints)o2;
        }
        if (o2 != null) {
            return new ContentHints(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private ContentHints(ASN1Sequence seq) {
        ASN1Encodable aSN1Encodable = seq.getObjectAt(0);
        if (aSN1Encodable.toASN1Primitive() instanceof DERUTF8String) {
            this.a = DERUTF8String.getInstance(aSN1Encodable);
            this.b = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(1));
        } else {
            this.b = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        }
    }

    public ContentHints(ASN1ObjectIdentifier contentType) {
        this.b = contentType;
        this.a = null;
    }

    public ContentHints(ASN1ObjectIdentifier contentType, DERUTF8String contentDescription) {
        this.b = contentType;
        this.a = contentDescription;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.b;
    }

    public DERUTF8String getContentDescription() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

