/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ess;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.ess.ESSCertIDv2;
import com.enterprisedt.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificateV2
extends ASN1Object {
    ASN1Sequence a;
    ASN1Sequence b;

    public static SigningCertificateV2 getInstance(Object o2) {
        if (o2 == null || o2 instanceof SigningCertificateV2) {
            return (SigningCertificateV2)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new SigningCertificateV2((ASN1Sequence)o2);
        }
        return null;
    }

    private SigningCertificateV2(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = ASN1Sequence.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.b = ASN1Sequence.getInstance(seq.getObjectAt(1));
        }
    }

    public SigningCertificateV2(ESSCertIDv2 cert) {
        this.a = new DERSequence(cert);
    }

    public SigningCertificateV2(ESSCertIDv2[] certs) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 < certs.length; ++i2) {
            aSN1EncodableVector.add(certs[i2]);
        }
        this.a = new DERSequence(aSN1EncodableVector);
    }

    public SigningCertificateV2(ESSCertIDv2[] certs, PolicyInformation[] policies) {
        int n2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (n2 = 0; n2 < certs.length; ++n2) {
            aSN1EncodableVector.add(certs[n2]);
        }
        this.a = new DERSequence(aSN1EncodableVector);
        if (policies != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            for (n2 = 0; n2 < policies.length; ++n2) {
                aSN1EncodableVector.add(policies[n2]);
            }
            this.b = new DERSequence(aSN1EncodableVector);
        }
    }

    public ESSCertIDv2[] getCerts() {
        ESSCertIDv2[] eSSCertIDv2Array = new ESSCertIDv2[this.a.size()];
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            eSSCertIDv2Array[i2] = ESSCertIDv2.getInstance(this.a.getObjectAt(i2));
        }
        return eSSCertIDv2Array;
    }

    public PolicyInformation[] getPolicies() {
        if (this.b == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            policyInformationArray[i2] = PolicyInformation.getInstance(this.b.getObjectAt(i2));
        }
        return policyInformationArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

