/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.isismtt.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.Certificate;
import java.io.IOException;

public class RequestedCertificate
extends ASN1Object
implements ASN1Choice {
    public static final int certificate = -1;
    public static final int publicKeyCertificate = 0;
    public static final int attributeCertificate = 1;
    private Certificate a;
    private byte[] b;
    private byte[] c;

    public static RequestedCertificate getInstance(Object obj) {
        if (obj == null || obj instanceof RequestedCertificate) {
            return (RequestedCertificate)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RequestedCertificate(Certificate.getInstance(obj));
        }
        if (obj instanceof ASN1TaggedObject) {
            return new RequestedCertificate((ASN1TaggedObject)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static RequestedCertificate getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("choice item must be explicitly tagged");
        }
        return RequestedCertificate.getInstance(obj.getObject());
    }

    private RequestedCertificate(ASN1TaggedObject tagged) {
        if (tagged.getTagNo() == 0) {
            this.b = ASN1OctetString.getInstance(tagged, true).getOctets();
        } else if (tagged.getTagNo() == 1) {
            this.c = ASN1OctetString.getInstance(tagged, true).getOctets();
        } else {
            throw new IllegalArgumentException("unknown tag number: " + tagged.getTagNo());
        }
    }

    public RequestedCertificate(Certificate certificate) {
        this.a = certificate;
    }

    public RequestedCertificate(int type, byte[] certificateOctets) {
        this(new DERTaggedObject(type, new DEROctetString(certificateOctets)));
    }

    public int getType() {
        if (this.a != null) {
            return -1;
        }
        if (this.b != null) {
            return 0;
        }
        return 1;
    }

    public byte[] getCertificateBytes() {
        if (this.a != null) {
            try {
                return this.a.getEncoded();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("can't decode certificate: " + iOException);
            }
        }
        if (this.b != null) {
            return this.b;
        }
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.b != null) {
            return new DERTaggedObject(0, new DEROctetString(this.b));
        }
        if (this.c != null) {
            return new DERTaggedObject(1, new DEROctetString(this.c));
        }
        return this.a.toASN1Primitive();
    }
}

