/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.isismtt.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import com.enterprisedt.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import java.util.Enumeration;

public class Admissions
extends ASN1Object {
    private GeneralName a;
    private NamingAuthority b;
    private ASN1Sequence c;

    public static Admissions getInstance(Object obj) {
        if (obj == null || obj instanceof Admissions) {
            return (Admissions)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new Admissions((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private Admissions(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration enumeration = seq.getObjects();
        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            switch (((ASN1TaggedObject)aSN1Encodable).getTagNo()) {
                case 0: {
                    this.a = GeneralName.getInstance((ASN1TaggedObject)aSN1Encodable, true);
                    break;
                }
                case 1: {
                    this.b = NamingAuthority.getInstance((ASN1TaggedObject)aSN1Encodable, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag number: " + ((ASN1TaggedObject)aSN1Encodable).getTagNo());
                }
            }
            aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        }
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            switch (((ASN1TaggedObject)aSN1Encodable).getTagNo()) {
                case 1: {
                    this.b = NamingAuthority.getInstance((ASN1TaggedObject)aSN1Encodable, true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag number: " + ((ASN1TaggedObject)aSN1Encodable).getTagNo());
                }
            }
            aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        }
        this.c = ASN1Sequence.getInstance(aSN1Encodable);
        if (enumeration.hasMoreElements()) {
            throw new IllegalArgumentException("Bad object encountered: " + enumeration.nextElement().getClass());
        }
    }

    public Admissions(GeneralName admissionAuthority, NamingAuthority namingAuthority, ProfessionInfo[] professionInfos) {
        this.a = admissionAuthority;
        this.b = namingAuthority;
        this.c = new DERSequence(professionInfos);
    }

    public GeneralName getAdmissionAuthority() {
        return this.a;
    }

    public NamingAuthority getNamingAuthority() {
        return this.b;
    }

    public ProfessionInfo[] getProfessionInfos() {
        ProfessionInfo[] professionInfoArray = new ProfessionInfo[this.c.size()];
        int n2 = 0;
        Enumeration enumeration = this.c.getObjects();
        while (enumeration.hasMoreElements()) {
            professionInfoArray[n2++] = ProfessionInfo.getInstance(enumeration.nextElement());
        }
        return professionInfoArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        }
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

