/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.isismtt.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.DirectoryString;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.IssuerSerial;
import java.util.Enumeration;

public class ProcurationSyntax
extends ASN1Object {
    private String a;
    private DirectoryString b;
    private GeneralName c;
    private IssuerSerial d;

    public static ProcurationSyntax getInstance(Object obj) {
        if (obj == null || obj instanceof ProcurationSyntax) {
            return (ProcurationSyntax)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new ProcurationSyntax((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private ProcurationSyntax(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        Enumeration enumeration = seq.getObjects();
        block5: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    this.a = DERPrintableString.getInstance(aSN1TaggedObject, true).getString();
                    continue block5;
                }
                case 2: {
                    this.b = DirectoryString.getInstance(aSN1TaggedObject, true);
                    continue block5;
                }
                case 3: {
                    ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
                    if (aSN1Primitive instanceof ASN1TaggedObject) {
                        this.c = GeneralName.getInstance(aSN1Primitive);
                        continue block5;
                    }
                    this.d = IssuerSerial.getInstance(aSN1Primitive);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public ProcurationSyntax(String country, DirectoryString typeOfSubstitution, IssuerSerial certRef) {
        this.a = country;
        this.b = typeOfSubstitution;
        this.c = null;
        this.d = certRef;
    }

    public ProcurationSyntax(String country, DirectoryString typeOfSubstitution, GeneralName thirdPerson) {
        this.a = country;
        this.b = typeOfSubstitution;
        this.c = thirdPerson;
        this.d = null;
    }

    public String getCountry() {
        return this.a;
    }

    public DirectoryString getTypeOfSubstitution() {
        return this.b;
    }

    public GeneralName getThirdPerson() {
        return this.c;
    }

    public IssuerSerial getCertRef() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, new DERPrintableString(this.a, true)));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, this.c));
        } else {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

