/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.nist;

import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.sec.SECNamedCurves;
import com.enterprisedt.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.util.Strings;
import java.util.Enumeration;
import java.util.Hashtable;

public class NISTNamedCurves {
    static final Hashtable a = new Hashtable();
    static final Hashtable b = new Hashtable();

    static void a(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        a.put(string, aSN1ObjectIdentifier);
        b.put(aSN1ObjectIdentifier, string);
    }

    public static X9ECParameters getByName(String name) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)a.get(Strings.toUpperCase(name));
        if (aSN1ObjectIdentifier != null) {
            return NISTNamedCurves.getByOID(aSN1ObjectIdentifier);
        }
        return null;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        return SECNamedCurves.getByOID(oid);
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        return (ASN1ObjectIdentifier)a.get(Strings.toUpperCase(name));
    }

    public static String getName(ASN1ObjectIdentifier oid) {
        return (String)b.get(oid);
    }

    public static Enumeration getNames() {
        return a.keys();
    }

    static {
        NISTNamedCurves.a("B-571", SECObjectIdentifiers.sect571r1);
        NISTNamedCurves.a("B-409", SECObjectIdentifiers.sect409r1);
        NISTNamedCurves.a("B-283", SECObjectIdentifiers.sect283r1);
        NISTNamedCurves.a("B-233", SECObjectIdentifiers.sect233r1);
        NISTNamedCurves.a("B-163", SECObjectIdentifiers.sect163r2);
        NISTNamedCurves.a("K-571", SECObjectIdentifiers.sect571k1);
        NISTNamedCurves.a("K-409", SECObjectIdentifiers.sect409k1);
        NISTNamedCurves.a("K-283", SECObjectIdentifiers.sect283k1);
        NISTNamedCurves.a("K-233", SECObjectIdentifiers.sect233k1);
        NISTNamedCurves.a("K-163", SECObjectIdentifiers.sect163k1);
        NISTNamedCurves.a("P-521", SECObjectIdentifiers.secp521r1);
        NISTNamedCurves.a("P-384", SECObjectIdentifiers.secp384r1);
        NISTNamedCurves.a("P-256", SECObjectIdentifiers.secp256r1);
        NISTNamedCurves.a("P-224", SECObjectIdentifiers.secp224r1);
        NISTNamedCurves.a("P-192", SECObjectIdentifiers.secp192r1);
    }
}

