/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERNull;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.ocsp.RevokedInfo;

public class CertStatus
extends ASN1Object
implements ASN1Choice {
    private int a;
    private ASN1Encodable b;

    public CertStatus() {
        this.a = 0;
        this.b = DERNull.INSTANCE;
    }

    public CertStatus(RevokedInfo info) {
        this.a = 1;
        this.b = info;
    }

    public CertStatus(int tagNo, ASN1Encodable value) {
        this.a = tagNo;
        this.b = value;
    }

    private CertStatus(ASN1TaggedObject choice) {
        this.a = choice.getTagNo();
        switch (choice.getTagNo()) {
            case 0: {
                this.b = DERNull.INSTANCE;
                break;
            }
            case 1: {
                this.b = RevokedInfo.getInstance(choice, false);
                break;
            }
            case 2: {
                this.b = DERNull.INSTANCE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown tag encountered: " + choice.getTagNo());
            }
        }
    }

    public static CertStatus getInstance(Object obj) {
        if (obj == null || obj instanceof CertStatus) {
            return (CertStatus)obj;
        }
        if (obj instanceof ASN1TaggedObject) {
            return new CertStatus((ASN1TaggedObject)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public static CertStatus getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertStatus.getInstance(obj.getObject());
    }

    public int getTagNo() {
        return this.a;
    }

    public ASN1Encodable getStatus() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.a, this.b);
    }
}

