/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;

public class TBSRequest
extends ASN1Object {
    private static final ASN1Integer f = new ASN1Integer(0L);
    ASN1Integer a;
    GeneralName b;
    ASN1Sequence c;
    Extensions d;
    boolean e;

    public TBSRequest(GeneralName requestorName, ASN1Sequence requestList, X509Extensions requestExtensions) {
        this.a = f;
        this.b = requestorName;
        this.c = requestList;
        this.d = Extensions.getInstance(requestExtensions);
    }

    public TBSRequest(GeneralName requestorName, ASN1Sequence requestList, Extensions requestExtensions) {
        this.a = f;
        this.b = requestorName;
        this.c = requestList;
        this.d = requestExtensions;
    }

    private TBSRequest(ASN1Sequence seq) {
        int n2 = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(0);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.e = true;
                this.a = ASN1Integer.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
                ++n2;
            } else {
                this.a = f;
            }
        } else {
            this.a = f;
        }
        if (seq.getObjectAt(n2) instanceof ASN1TaggedObject) {
            this.b = GeneralName.getInstance((ASN1TaggedObject)seq.getObjectAt(n2++), true);
        }
        this.c = (ASN1Sequence)seq.getObjectAt(n2++);
        if (seq.size() == n2 + 1) {
            this.d = Extensions.getInstance((ASN1TaggedObject)seq.getObjectAt(n2), true);
        }
    }

    public static TBSRequest getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSRequest.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSRequest getInstance(Object obj) {
        if (obj instanceof TBSRequest) {
            return (TBSRequest)obj;
        }
        if (obj != null) {
            return new TBSRequest(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public GeneralName getRequestorName() {
        return this.b;
    }

    public ASN1Sequence getRequestList() {
        return this.c;
    }

    public Extensions getRequestExtensions() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (!this.a.equals(f) || this.e) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, this.b));
        }
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

