/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DERSequence;

public class Attribute
extends ASN1Object {
    private ASN1ObjectIdentifier a;
    private ASN1Set b;

    public static Attribute getInstance(Object o2) {
        if (o2 == null || o2 instanceof Attribute) {
            return (Attribute)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new Attribute((ASN1Sequence)o2);
        }
        throw new IllegalArgumentException("unknown object in factory: " + o2.getClass().getName());
    }

    public Attribute(ASN1Sequence seq) {
        this.a = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.b = (ASN1Set)seq.getObjectAt(1);
    }

    public Attribute(ASN1ObjectIdentifier attrType, ASN1Set attrValues) {
        this.a = attrType;
        this.b = attrValues;
    }

    public ASN1ObjectIdentifier getAttrType() {
        return this.a;
    }

    public ASN1Set getAttrValues() {
        return this.b;
    }

    public ASN1Encodable[] getAttributeValues() {
        return this.b.toArray();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        return new DERSequence(aSN1EncodableVector);
    }
}

