/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.pkcs.Attribute;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.X509Name;
import java.util.Enumeration;

public class CertificationRequestInfo
extends ASN1Object {
    ASN1Integer a = new ASN1Integer(0L);
    X500Name b;
    SubjectPublicKeyInfo c;
    ASN1Set d = null;

    public static CertificationRequestInfo getInstance(Object obj) {
        if (obj instanceof CertificationRequestInfo) {
            return (CertificationRequestInfo)obj;
        }
        if (obj != null) {
            return new CertificationRequestInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public CertificationRequestInfo(X500Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        if (subject == null || pkInfo == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
        CertificationRequestInfo.a(attributes);
        this.b = subject;
        this.c = pkInfo;
        this.d = attributes;
    }

    public CertificationRequestInfo(X509Name subject, SubjectPublicKeyInfo pkInfo, ASN1Set attributes) {
        this(X500Name.getInstance(subject.toASN1Primitive()), pkInfo, attributes);
    }

    public CertificationRequestInfo(ASN1Sequence seq) {
        this.a = (ASN1Integer)seq.getObjectAt(0);
        this.b = X500Name.getInstance(seq.getObjectAt(1));
        this.c = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(2));
        if (seq.size() > 3) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(3);
            this.d = ASN1Set.getInstance(aSN1TaggedObject, false);
        }
        CertificationRequestInfo.a(this.d);
        if (this.b == null || this.a == null || this.c == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public X500Name getSubject() {
        return this.b;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.c;
    }

    public ASN1Set getAttributes() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    private static void a(ASN1Set aSN1Set) {
        if (aSN1Set == null) {
            return;
        }
        Enumeration enumeration = aSN1Set.getObjects();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = Attribute.getInstance(enumeration.nextElement());
            if (!attribute.getAttrType().equals(PKCSObjectIdentifiers.pkcs_9_at_challengePassword) || attribute.getAttrValues().size() == 1) continue;
            throw new IllegalArgumentException("challengePassword attribute must have one value");
        }
    }
}

