/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;

public class PBEParameter
extends ASN1Object {
    ASN1Integer a;
    ASN1OctetString b;

    public PBEParameter(byte[] salt, int iterations) {
        if (salt.length != 8) {
            throw new IllegalArgumentException("salt length must be 8");
        }
        this.b = new DEROctetString(salt);
        this.a = new ASN1Integer(iterations);
    }

    private PBEParameter(ASN1Sequence seq) {
        this.b = (ASN1OctetString)seq.getObjectAt(0);
        this.a = (ASN1Integer)seq.getObjectAt(1);
    }

    public static PBEParameter getInstance(Object obj) {
        if (obj instanceof PBEParameter) {
            return (PBEParameter)obj;
        }
        if (obj != null) {
            return new PBEParameter(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public BigInteger getIterationCount() {
        return this.a.getValue();
    }

    public byte[] getSalt() {
        return this.b.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.a);
        return new DERSequence(aSN1EncodableVector);
    }
}

