/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.BERSequence;
import com.enterprisedt.bouncycastle.asn1.pkcs.ContentInfo;
import com.enterprisedt.bouncycastle.asn1.pkcs.MacData;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.math.BigInteger;

public class Pfx
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ContentInfo a;
    private MacData b = null;

    private Pfx(ASN1Sequence seq) {
        BigInteger bigInteger = ASN1Integer.getInstance(seq.getObjectAt(0)).getValue();
        if (bigInteger.intValue() != 3) {
            throw new IllegalArgumentException("wrong version for PFX PDU");
        }
        this.a = ContentInfo.getInstance(seq.getObjectAt(1));
        if (seq.size() == 3) {
            this.b = MacData.getInstance(seq.getObjectAt(2));
        }
    }

    public static Pfx getInstance(Object obj) {
        if (obj instanceof Pfx) {
            return (Pfx)obj;
        }
        if (obj != null) {
            return new Pfx(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public Pfx(ContentInfo contentInfo, MacData macData) {
        this.a = contentInfo;
        this.b = macData;
    }

    public ContentInfo getAuthSafe() {
        return this.a;
    }

    public MacData getMacData() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(3L));
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

