/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.smime;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.cms.Attribute;
import com.enterprisedt.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.smime.SMIMECapability;
import java.util.Enumeration;
import java.util.Vector;

public class SMIMECapabilities
extends ASN1Object {
    public static final ASN1ObjectIdentifier preferSignedData = PKCSObjectIdentifiers.preferSignedData;
    public static final ASN1ObjectIdentifier canNotDecryptAny = PKCSObjectIdentifiers.canNotDecryptAny;
    public static final ASN1ObjectIdentifier sMIMECapabilitesVersions = PKCSObjectIdentifiers.sMIMECapabilitiesVersions;
    public static final ASN1ObjectIdentifier aes256_CBC = NISTObjectIdentifiers.id_aes256_CBC;
    public static final ASN1ObjectIdentifier aes192_CBC = NISTObjectIdentifiers.id_aes192_CBC;
    public static final ASN1ObjectIdentifier aes128_CBC = NISTObjectIdentifiers.id_aes128_CBC;
    public static final ASN1ObjectIdentifier idea_CBC = new ASN1ObjectIdentifier("1.3.6.1.4.1.188.7.1.1.2");
    public static final ASN1ObjectIdentifier cast5_CBC = new ASN1ObjectIdentifier("1.2.840.113533.7.66.10");
    public static final ASN1ObjectIdentifier dES_CBC = new ASN1ObjectIdentifier("1.3.14.3.2.7");
    public static final ASN1ObjectIdentifier dES_EDE3_CBC = PKCSObjectIdentifiers.des_EDE3_CBC;
    public static final ASN1ObjectIdentifier rC2_CBC = PKCSObjectIdentifiers.RC2_CBC;
    private ASN1Sequence a;

    public static SMIMECapabilities getInstance(Object o2) {
        if (o2 == null || o2 instanceof SMIMECapabilities) {
            return (SMIMECapabilities)o2;
        }
        if (o2 instanceof ASN1Sequence) {
            return new SMIMECapabilities((ASN1Sequence)o2);
        }
        if (o2 instanceof Attribute) {
            return new SMIMECapabilities((ASN1Sequence)((Attribute)o2).getAttrValues().getObjectAt(0));
        }
        throw new IllegalArgumentException("unknown object in factory: " + o2.getClass().getName());
    }

    public SMIMECapabilities(ASN1Sequence seq) {
        this.a = seq;
    }

    public Vector getCapabilities(ASN1ObjectIdentifier capability) {
        Enumeration enumeration = this.a.getObjects();
        Vector<SMIMECapability> vector = new Vector<SMIMECapability>();
        if (capability == null) {
            while (enumeration.hasMoreElements()) {
                SMIMECapability sMIMECapability = SMIMECapability.getInstance(enumeration.nextElement());
                vector.addElement(sMIMECapability);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                SMIMECapability sMIMECapability = SMIMECapability.getInstance(enumeration.nextElement());
                if (!capability.equals(sMIMECapability.getCapabilityID())) continue;
                vector.addElement(sMIMECapability);
            }
        }
        return vector;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

