/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.tsp;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;

public class Accuracy
extends ASN1Object {
    ASN1Integer a;
    ASN1Integer b;
    ASN1Integer c;
    protected static final int MIN_MILLIS = 1;
    protected static final int MAX_MILLIS = 999;
    protected static final int MIN_MICROS = 1;
    protected static final int MAX_MICROS = 999;

    protected Accuracy() {
    }

    public Accuracy(ASN1Integer seconds, ASN1Integer millis, ASN1Integer micros) {
        this.a = seconds;
        if (millis != null && (millis.getValue().intValue() < 1 || millis.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
        this.b = millis;
        if (micros != null && (micros.getValue().intValue() < 1 || micros.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
        }
        this.c = micros;
    }

    private Accuracy(ASN1Sequence seq) {
        this.a = null;
        this.b = null;
        this.c = null;
        block4: for (int i2 = 0; i2 < seq.size(); ++i2) {
            if (seq.getObjectAt(i2) instanceof ASN1Integer) {
                this.a = (ASN1Integer)seq.getObjectAt(i2);
                continue;
            }
            if (!(seq.getObjectAt(i2) instanceof ASN1TaggedObject)) continue;
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(i2);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.b = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    if (this.b.getValue().intValue() >= 1 && this.b.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid millis field : not in (1..999).");
                }
                case 1: {
                    this.c = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    if (this.c.getValue().intValue() >= 1 && this.c.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid micros field : not in (1..999).");
                }
                default: {
                    throw new IllegalArgumentException("Invalig tag number");
                }
            }
        }
    }

    public static Accuracy getInstance(Object o2) {
        if (o2 instanceof Accuracy) {
            return (Accuracy)o2;
        }
        if (o2 != null) {
            return new Accuracy(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ASN1Integer getSeconds() {
        return this.a;
    }

    public ASN1Integer getMillis() {
        return this.b;
    }

    public ASN1Integer getMicros() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

