/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBMPString;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.asn1.DERT61String;
import com.enterprisedt.bouncycastle.asn1.DERUTF8String;
import com.enterprisedt.bouncycastle.asn1.DERUniversalString;

public class DirectoryString
extends ASN1Object
implements ASN1Choice,
ASN1String {
    private ASN1String a;

    public static DirectoryString getInstance(Object o2) {
        if (o2 == null || o2 instanceof DirectoryString) {
            return (DirectoryString)o2;
        }
        if (o2 instanceof DERT61String) {
            return new DirectoryString((DERT61String)o2);
        }
        if (o2 instanceof DERPrintableString) {
            return new DirectoryString((DERPrintableString)o2);
        }
        if (o2 instanceof DERUniversalString) {
            return new DirectoryString((DERUniversalString)o2);
        }
        if (o2 instanceof DERUTF8String) {
            return new DirectoryString((DERUTF8String)o2);
        }
        if (o2 instanceof DERBMPString) {
            return new DirectoryString((DERBMPString)o2);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + o2.getClass().getName());
    }

    public static DirectoryString getInstance(ASN1TaggedObject o2, boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("choice item must be explicitly tagged");
        }
        return DirectoryString.getInstance(o2.getObject());
    }

    private DirectoryString(DERT61String string) {
        this.a = string;
    }

    private DirectoryString(DERPrintableString string) {
        this.a = string;
    }

    private DirectoryString(DERUniversalString string) {
        this.a = string;
    }

    private DirectoryString(DERUTF8String string) {
        this.a = string;
    }

    private DirectoryString(DERBMPString string) {
        this.a = string;
    }

    public DirectoryString(String string) {
        this.a = new DERUTF8String(string);
    }

    @Override
    public String getString() {
        return this.a.getString();
    }

    public String toString() {
        return this.a.getString();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return ((ASN1Encodable)((Object)this.a)).toASN1Primitive();
    }
}

