/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERSet;
import com.enterprisedt.bouncycastle.asn1.x500.AttributeTypeAndValue;

public class RDN
extends ASN1Object {
    private ASN1Set a;

    private RDN(ASN1Set values) {
        this.a = values;
    }

    public static RDN getInstance(Object obj) {
        if (obj instanceof RDN) {
            return (RDN)obj;
        }
        if (obj != null) {
            return new RDN(ASN1Set.getInstance(obj));
        }
        return null;
    }

    public RDN(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(oid);
        aSN1EncodableVector.add(value);
        this.a = new DERSet(new DERSequence(aSN1EncodableVector));
    }

    public RDN(AttributeTypeAndValue attrTAndV) {
        this.a = new DERSet(attrTAndV);
    }

    public RDN(AttributeTypeAndValue[] aAndVs) {
        this.a = new DERSet(aAndVs);
    }

    public boolean isMultiValued() {
        return this.a.size() > 1;
    }

    public int size() {
        return this.a.size();
    }

    public AttributeTypeAndValue getFirst() {
        if (this.a.size() == 0) {
            return null;
        }
        return AttributeTypeAndValue.getInstance(this.a.getObjectAt(0));
    }

    public AttributeTypeAndValue[] getTypesAndValues() {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[this.a.size()];
        for (int i2 = 0; i2 != attributeTypeAndValueArray.length; ++i2) {
            attributeTypeAndValueArray[i2] = AttributeTypeAndValue.getInstance(this.a.getObjectAt(i2));
        }
        return attributeTypeAndValueArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

