/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.enterprisedt.bouncycastle.asn1.x500.RDN;
import com.enterprisedt.bouncycastle.asn1.x500.X500NameStyle;
import com.enterprisedt.bouncycastle.asn1.x500.style.BCStyle;
import java.util.Enumeration;

public class X500Name
extends ASN1Object
implements ASN1Choice {
    private static X500NameStyle a = BCStyle.INSTANCE;
    private boolean b;
    private int c;
    private X500NameStyle d;
    private RDN[] e;

    public X500Name(X500NameStyle style, X500Name name) {
        this.e = name.e;
        this.d = style;
    }

    public static X500Name getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X500Name.getInstance(ASN1Sequence.getInstance(obj, true));
    }

    public static X500Name getInstance(Object obj) {
        if (obj instanceof X500Name) {
            return (X500Name)obj;
        }
        if (obj != null) {
            return new X500Name(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static X500Name getInstance(X500NameStyle style, Object obj) {
        if (obj instanceof X500Name) {
            return new X500Name(style, (X500Name)obj);
        }
        if (obj != null) {
            return new X500Name(style, ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private X500Name(ASN1Sequence seq) {
        this(a, seq);
    }

    private X500Name(X500NameStyle style, ASN1Sequence seq) {
        this.d = style;
        this.e = new RDN[seq.size()];
        int n2 = 0;
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            this.e[n2++] = RDN.getInstance(enumeration.nextElement());
        }
    }

    public X500Name(RDN[] rDNs) {
        this(a, rDNs);
    }

    public X500Name(X500NameStyle style, RDN[] rDNs) {
        this.e = rDNs;
        this.d = style;
    }

    public X500Name(String dirName) {
        this(a, dirName);
    }

    public X500Name(X500NameStyle style, String dirName) {
        this(style.fromString(dirName));
        this.d = style;
    }

    public RDN[] getRDNs() {
        RDN[] rDNArray = new RDN[this.e.length];
        System.arraycopy(this.e, 0, rDNArray, 0, rDNArray.length);
        return rDNArray;
    }

    public ASN1ObjectIdentifier[] getAttributeTypes() {
        int n2 = 0;
        for (int i2 = 0; i2 != this.e.length; ++i2) {
            RDN rDN = this.e[i2];
            n2 += rDN.size();
        }
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[n2];
        n2 = 0;
        for (int i3 = 0; i3 != this.e.length; ++i3) {
            RDN rDN = this.e[i3];
            if (rDN.isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDN.getTypesAndValues();
                for (int i4 = 0; i4 != attributeTypeAndValueArray.length; ++i4) {
                    aSN1ObjectIdentifierArray[n2++] = attributeTypeAndValueArray[i4].getType();
                }
                continue;
            }
            if (rDN.size() == 0) continue;
            aSN1ObjectIdentifierArray[n2++] = rDN.getFirst().getType();
        }
        return aSN1ObjectIdentifierArray;
    }

    public RDN[] getRDNs(ASN1ObjectIdentifier attributeType) {
        RDN[] rDNArray = new RDN[this.e.length];
        int n2 = 0;
        block0: for (int i2 = 0; i2 != this.e.length; ++i2) {
            RDN rDN = this.e[i2];
            if (rDN.isMultiValued()) {
                AttributeTypeAndValue[] attributeTypeAndValueArray = rDN.getTypesAndValues();
                for (int i3 = 0; i3 != attributeTypeAndValueArray.length; ++i3) {
                    if (!attributeTypeAndValueArray[i3].getType().equals(attributeType)) continue;
                    rDNArray[n2++] = rDN;
                    continue block0;
                }
                continue;
            }
            if (!rDN.getFirst().getType().equals(attributeType)) continue;
            rDNArray[n2++] = rDN;
        }
        RDN[] rDNArray2 = new RDN[n2];
        System.arraycopy(rDNArray, 0, rDNArray2, 0, rDNArray2.length);
        return rDNArray2;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.e);
    }

    @Override
    public int hashCode() {
        if (this.b) {
            return this.c;
        }
        this.b = true;
        this.c = this.d.calculateHashCode(this);
        return this.c;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof X500Name) && !(obj instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
        if (this.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            return this.d.areEqual(this, new X500Name(ASN1Sequence.getInstance(((ASN1Encodable)obj).toASN1Primitive())));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.d.toString(this);
    }

    public static void setDefaultStyle(X500NameStyle style) {
        if (style == null) {
            throw new NullPointerException("cannot set style to null");
        }
        a = style;
    }

    public static X500NameStyle getDefaultStyle() {
        return a;
    }
}

