/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500.style;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.DERUniversalString;
import com.enterprisedt.bouncycastle.asn1.x500.AttributeTypeAndValue;
import com.enterprisedt.bouncycastle.asn1.x500.RDN;
import com.enterprisedt.bouncycastle.asn1.x500.X500NameBuilder;
import com.enterprisedt.bouncycastle.asn1.x500.X500NameStyle;
import com.enterprisedt.bouncycastle.asn1.x500.style.X500NameTokenizer;
import com.enterprisedt.bouncycastle.util.Strings;
import com.enterprisedt.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IETFUtils {
    private static String a(String string) {
        if (string.length() == 0 || string.indexOf(92) < 0 && string.indexOf(34) < 0) {
            return string.trim();
        }
        char[] cArray = string.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        if (cArray[0] == '\\' && cArray[1] == '#') {
            n2 = 2;
            stringBuffer.append("\\#");
        }
        boolean bl3 = false;
        int n3 = 0;
        char c2 = '\u0000';
        for (int i2 = n2; i2 != cArray.length; ++i2) {
            char c3 = cArray[i2];
            if (c3 != ' ') {
                bl3 = true;
            }
            if (c3 == '\"') {
                if (!bl) {
                    bl2 = !bl2;
                } else {
                    stringBuffer.append(c3);
                }
                bl = false;
                continue;
            }
            if (c3 == '\\' && !bl && !bl2) {
                bl = true;
                n3 = stringBuffer.length();
                continue;
            }
            if (c3 == ' ' && !bl && !bl3) continue;
            if (bl && IETFUtils.a(c3)) {
                if (c2 != '\u0000') {
                    stringBuffer.append((char)(IETFUtils.b(c2) * 16 + IETFUtils.b(c3)));
                    bl = false;
                    c2 = '\u0000';
                    continue;
                }
                c2 = c3;
                continue;
            }
            stringBuffer.append(c3);
            bl = false;
        }
        if (stringBuffer.length() > 0) {
            while (stringBuffer.charAt(stringBuffer.length() - 1) == ' ' && n3 != stringBuffer.length() - 1) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }

    private static boolean a(char c2) {
        return '0' <= c2 && c2 <= '9' || 'a' <= c2 && c2 <= 'f' || 'A' <= c2 && c2 <= 'F';
    }

    private static int b(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        return c2 - 65 + 10;
    }

    public static RDN[] rDNsFromString(String name, X500NameStyle x500Style) {
        X500NameTokenizer x500NameTokenizer = new X500NameTokenizer(name);
        X500NameBuilder x500NameBuilder = new X500NameBuilder(x500Style);
        while (x500NameTokenizer.hasMoreTokens()) {
            Object object;
            String string;
            Object object2;
            X500NameTokenizer x500NameTokenizer2;
            String string2 = x500NameTokenizer.nextToken();
            if (string2.indexOf(43) > 0) {
                x500NameTokenizer2 = new X500NameTokenizer(string2, '+');
                object2 = new X500NameTokenizer(x500NameTokenizer2.nextToken(), '=');
                string = ((X500NameTokenizer)object2).nextToken();
                if (!((X500NameTokenizer)object2).hasMoreTokens()) {
                    throw new IllegalArgumentException("badly formatted directory string");
                }
                object = ((X500NameTokenizer)object2).nextToken();
                ASN1ObjectIdentifier aSN1ObjectIdentifier = x500Style.attrNameToOID(string.trim());
                if (x500NameTokenizer2.hasMoreTokens()) {
                    Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
                    Vector<String> vector2 = new Vector<String>();
                    vector.addElement(aSN1ObjectIdentifier);
                    vector2.addElement(IETFUtils.a((String)object));
                    while (x500NameTokenizer2.hasMoreTokens()) {
                        object2 = new X500NameTokenizer(x500NameTokenizer2.nextToken(), '=');
                        string = ((X500NameTokenizer)object2).nextToken();
                        if (!((X500NameTokenizer)object2).hasMoreTokens()) {
                            throw new IllegalArgumentException("badly formatted directory string");
                        }
                        object = ((X500NameTokenizer)object2).nextToken();
                        aSN1ObjectIdentifier = x500Style.attrNameToOID(string.trim());
                        vector.addElement(aSN1ObjectIdentifier);
                        vector2.addElement(IETFUtils.a((String)object));
                    }
                    x500NameBuilder.addMultiValuedRDN(IETFUtils.b(vector), IETFUtils.a(vector2));
                    continue;
                }
                x500NameBuilder.addRDN(aSN1ObjectIdentifier, IETFUtils.a((String)object));
                continue;
            }
            x500NameTokenizer2 = new X500NameTokenizer(string2, '=');
            object2 = x500NameTokenizer2.nextToken();
            if (!x500NameTokenizer2.hasMoreTokens()) {
                throw new IllegalArgumentException("badly formatted directory string");
            }
            string = x500NameTokenizer2.nextToken();
            object = x500Style.attrNameToOID(((String)object2).trim());
            x500NameBuilder.addRDN((ASN1ObjectIdentifier)object, IETFUtils.a(string));
        }
        return x500NameBuilder.build().getRDNs();
    }

    private static String[] a(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i2 = 0; i2 != stringArray.length; ++i2) {
            stringArray[i2] = (String)vector.elementAt(i2);
        }
        return stringArray;
    }

    private static ASN1ObjectIdentifier[] b(Vector vector) {
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[vector.size()];
        for (int i2 = 0; i2 != aSN1ObjectIdentifierArray.length; ++i2) {
            aSN1ObjectIdentifierArray[i2] = (ASN1ObjectIdentifier)vector.elementAt(i2);
        }
        return aSN1ObjectIdentifierArray;
    }

    public static String[] findAttrNamesForOID(ASN1ObjectIdentifier oid, Hashtable lookup) {
        int n2 = 0;
        String[] stringArray = lookup.elements();
        while (stringArray.hasMoreElements()) {
            if (!oid.equals(stringArray.nextElement())) continue;
            ++n2;
        }
        stringArray = new String[n2];
        n2 = 0;
        Enumeration enumeration = lookup.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!oid.equals(lookup.get(string))) continue;
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    public static ASN1ObjectIdentifier decodeAttrName(String name, Hashtable lookUp) {
        if (Strings.toUpperCase(name).startsWith("OID.")) {
            return new ASN1ObjectIdentifier(name.substring(4));
        }
        if (name.charAt(0) >= '0' && name.charAt(0) <= '9') {
            return new ASN1ObjectIdentifier(name);
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)lookUp.get(Strings.toLowerCase(name));
        if (aSN1ObjectIdentifier == null) {
            throw new IllegalArgumentException("Unknown object id - " + name + " - passed to distinguished name");
        }
        return aSN1ObjectIdentifier;
    }

    public static ASN1Encodable valueFromHexString(String str, int off) throws IOException {
        byte[] byArray = new byte[(str.length() - off) / 2];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            char c2 = str.charAt(i2 * 2 + off);
            char c3 = str.charAt(i2 * 2 + off + 1);
            byArray[i2] = (byte)(IETFUtils.b(c2) << 4 | IETFUtils.b(c3));
        }
        return ASN1Primitive.fromByteArray(byArray);
    }

    public static void appendRDN(StringBuffer buf, RDN rdn, Hashtable oidSymbols) {
        if (rdn.isMultiValued()) {
            AttributeTypeAndValue[] attributeTypeAndValueArray = rdn.getTypesAndValues();
            boolean bl = true;
            for (int i2 = 0; i2 != attributeTypeAndValueArray.length; ++i2) {
                if (bl) {
                    bl = false;
                } else {
                    buf.append('+');
                }
                IETFUtils.appendTypeAndValue(buf, attributeTypeAndValueArray[i2], oidSymbols);
            }
        } else if (rdn.getFirst() != null) {
            IETFUtils.appendTypeAndValue(buf, rdn.getFirst(), oidSymbols);
        }
    }

    public static void appendTypeAndValue(StringBuffer buf, AttributeTypeAndValue typeAndValue, Hashtable oidSymbols) {
        String string = (String)oidSymbols.get(typeAndValue.getType());
        if (string != null) {
            buf.append(string);
        } else {
            buf.append(typeAndValue.getType().getId());
        }
        buf.append('=');
        buf.append(IETFUtils.valueToString(typeAndValue.getValue()));
    }

    public static String valueToString(ASN1Encodable value) {
        StringBuffer stringBuffer = new StringBuffer();
        if (value instanceof ASN1String && !(value instanceof DERUniversalString)) {
            String string = ((ASN1String)((Object)value)).getString();
            if (string.length() > 0 && string.charAt(0) == '#') {
                stringBuffer.append("\\" + string);
            } else {
                stringBuffer.append(string);
            }
        } else {
            try {
                stringBuffer.append("#" + IETFUtils.a(Hex.encode(value.toASN1Primitive().getEncoded("DER"))));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Other value has no encoded form");
            }
        }
        int n2 = stringBuffer.length();
        int n3 = 0;
        if (stringBuffer.length() >= 2 && stringBuffer.charAt(0) == '\\' && stringBuffer.charAt(1) == '#') {
            n3 += 2;
        }
        while (n3 != n2) {
            if (stringBuffer.charAt(n3) == ',' || stringBuffer.charAt(n3) == '\"' || stringBuffer.charAt(n3) == '\\' || stringBuffer.charAt(n3) == '+' || stringBuffer.charAt(n3) == '=' || stringBuffer.charAt(n3) == '<' || stringBuffer.charAt(n3) == '>' || stringBuffer.charAt(n3) == ';') {
                stringBuffer.insert(n3, "\\");
                ++n3;
                ++n2;
            }
            ++n3;
        }
        if (stringBuffer.length() > 0) {
            for (int i2 = 0; stringBuffer.length() > i2 && stringBuffer.charAt(i2) == ' '; i2 += 2) {
                stringBuffer.insert(i2, "\\");
            }
        }
        for (int i3 = stringBuffer.length() - 1; i3 >= 0 && stringBuffer.charAt(i3) == ' '; --i3) {
            stringBuffer.insert(i3, '\\');
        }
        return stringBuffer.toString();
    }

    private static String a(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i2 = 0; i2 != cArray.length; ++i2) {
            cArray[i2] = (char)(byArray[i2] & 0xFF);
        }
        return new String(cArray);
    }

    public static String canonicalize(String s2) {
        ASN1Primitive aSN1Primitive;
        String string = Strings.toLowerCase(s2);
        if (string.length() > 0 && string.charAt(0) == '#' && (aSN1Primitive = IETFUtils.b(string)) instanceof ASN1String) {
            string = Strings.toLowerCase(((ASN1String)((Object)aSN1Primitive)).getString());
        }
        if (string.length() > 1) {
            int n2 = 0;
            while (n2 + 1 < string.length() && string.charAt(n2) == '\\' && string.charAt(n2 + 1) == ' ') {
                n2 += 2;
            }
            int n3 = string.length() - 1;
            while (n3 - 1 > 0 && string.charAt(n3 - 1) == '\\' && string.charAt(n3) == ' ') {
                n3 -= 2;
            }
            if (n2 > 0 || n3 < string.length() - 1) {
                string = string.substring(n2, n3 + 1);
            }
        }
        string = IETFUtils.stripInternalSpaces(string);
        return string;
    }

    private static ASN1Primitive b(String string) {
        try {
            return ASN1Primitive.fromByteArray(Hex.decode(string.substring(1)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unknown encoding in name: " + iOException);
        }
    }

    public static String stripInternalSpaces(String str) {
        StringBuffer stringBuffer = new StringBuffer();
        if (str.length() != 0) {
            char c2 = str.charAt(0);
            stringBuffer.append(c2);
            for (int i2 = 1; i2 < str.length(); ++i2) {
                char c3 = str.charAt(i2);
                if (c2 != ' ' || c3 != ' ') {
                    stringBuffer.append(c3);
                }
                c2 = c3;
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean rDNAreEqual(RDN rdn1, RDN rdn2) {
        if (rdn1.isMultiValued()) {
            AttributeTypeAndValue[] attributeTypeAndValueArray;
            if (!rdn2.isMultiValued()) return false;
            AttributeTypeAndValue[] attributeTypeAndValueArray2 = rdn1.getTypesAndValues();
            if (attributeTypeAndValueArray2.length != (attributeTypeAndValueArray = rdn2.getTypesAndValues()).length) {
                return false;
            }
            for (int i2 = 0; i2 != attributeTypeAndValueArray2.length; ++i2) {
                if (IETFUtils.a(attributeTypeAndValueArray2[i2], attributeTypeAndValueArray[i2])) continue;
                return false;
            }
            return true;
        } else {
            if (rdn2.isMultiValued()) return false;
            return IETFUtils.a(rdn1.getFirst(), rdn2.getFirst());
        }
    }

    private static boolean a(AttributeTypeAndValue attributeTypeAndValue, AttributeTypeAndValue attributeTypeAndValue2) {
        String string;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (attributeTypeAndValue == attributeTypeAndValue2) {
            return true;
        }
        if (attributeTypeAndValue == null) {
            return false;
        }
        if (attributeTypeAndValue2 == null) {
            return false;
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = attributeTypeAndValue.getType();
        if (!aSN1ObjectIdentifier2.equals(aSN1ObjectIdentifier = attributeTypeAndValue2.getType())) {
            return false;
        }
        String string2 = IETFUtils.canonicalize(IETFUtils.valueToString(attributeTypeAndValue.getValue()));
        return string2.equals(string = IETFUtils.canonicalize(IETFUtils.valueToString(attributeTypeAndValue2.getValue())));
    }
}

